% Transition4.m   3/20/13
%
%  Show results for a given set of parameter values.
%
%  Numerical solution of transition dxnamics for the life & growth model
%  See 2013-03-14-NumericalSolution.pdf
%
% The system of 6 differential equations 
%
%   x=[s,ell,sigma,dlta,y,z]   y==gA  z==gB
%  dx=transit1dx(t,x,alpha,beta,lambda,phi,ubar,gamma,rho,nbar);
%
%  Version 4:  October 2014 

clear all; startup


if exist('Transition4.log'); delete('Transition4.log'); end;
diary Transition4.log;
fprintf(['Transition4                 ' date]);
disp ' ';
disp ' ';
help Transition4

% Change font size
%set(0,'defaultAxesFontSize',18);
%set(0,'defaultTextFontSize',18);

% Parameters
mygreen=[0 .6 .4];
mypurp=[.8 .1 .6];
lw=3;   % Line width for graphs

% Key Values
% Initial guess
gamma=2.6953   % 2.6455
beta=0.6006
ubar=1e-3
lambda=.5377
dlta0=2e-4
phi=5/6


% Other fixed parameters
rho=.02
alpha=1  % 2 percent growth
nbar=.01
T=1000
tstep=1


% Get solution
ShowResults=1;
[t,x,chat,hhat,gdpgrowth,vtilde,shat,ellhat]=solvetransition(ubar,beta,gamma,dlta0,alpha,lambda,phi,rho,nbar,T,tstep,ShowResults);

% Recover the key variables
s=x(:,1);
ell=x(:,2);
sigma=x(:,3);
dlta=x(:,4);
y=x(:,5);
z=x(:,6);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Transition plot
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
myblue=[0 .1 .8];
tstart=679  % Starting point for "nice" plots -- make this time 0
t=t-tstart;
ii=find(t>=0);
t=t(ii);
today=66
ttoday=find(t==today)

% Note well: t goes in *reverse* order

% Growth rates
figure(1); figsetup;
plot(t,y(ii),'--','Color','b','LineWidth',lw); hold on;
plot(t,z(ii),'--','Color',mygreen,'LineWidth',lw);
plot(t,chat(ii),'-','Color','b','LineWidth',lw);
plot(t,hhat(ii),'-','Color',mygreen,'LineWidth',lw);
plot(t,gdpgrowth(ii),'-','Color',mypurp,'LineWidth',5);
%plot([ttoday ttoday],[0 .049],'k--','LineWidth',1);
% Highlight today
plot(t(ttoday),y(ttoday),'o','Color','b','LineWidth',lw,'MarkerFaceColor','b'); 
plot(t(ttoday),z(ttoday),'o','Color',mygreen,'LineWidth',lw,'MarkerFaceColor',mygreen);
plot(t(ttoday),chat(ttoday),'o','Color','b','LineWidth',lw);
plot(t(ttoday),hhat(ttoday),'o','Color',mygreen,'LineWidth',lw);
plot(t(ttoday),gdpgrowth(ttoday),'o','Color',mypurp,'LineWidth',lw+1);
ax=axis; ax(4)=.05; ax(2)=340; axis(ax);
chadfig('Time','              Growth rate',1,0);
makefigwide;
set(gca,'YTickLabel',strmat('0 1% 2% 3% 4% 5%'));
set(gca,'YTick',[0 .01 .02 .03 .04 .05]);
text(135,.03,'Life output, $h$','Color',mygreen,'interpreter','latex');
text(80,.007,'Life ideas, $B$','Color',mygreen,'interpreter','latex');
text(250,.0115,'Consumption, $c$','Color','b','interpreter','latex');
text(225,.02,'Consumption ideas, $A$','Color','b','interpreter','latex');
text(260,.025,'Per capita GDP','Color',mypurp,'interpreter','latex');
print Transition4a.eps

% Labor allocation
figure(2); figsetup;
plot(t,100*sigma(ii),'b-','LineWidth',lw); hold on;
plot(t,100*ell(ii),'-','Color',mygreen,'LineWidth',lw);
plot(t,100*s(ii),'-','Color',mypurp,'LineWidth',lw);
ax=axis; ax(1)=0; ax(2)=340; axis(ax);
%plot([ttoday ttoday],[0 99],'k--','LineWidth',1);
% Highlight today
plot(t(ttoday),100*sigma(ttoday),'bo','LineWidth',lw);
plot(t(ttoday),100*ell(ttoday),'o','Color',mygreen,'LineWidth',lw);
plot(t(ttoday),100*s(ttoday),'o','Color',mypurp,'LineWidth',lw);
chadfig('Time','Percent',1,0);
makefigwide;
text(100,69,'Share of scientists in $c$ sector, $s$','Color',mypurp,'interpreter','latex');
text(5,63,mlstring('Consump.\\ \% of GDP, \\ \ \ \ \ \ $\ell$'),'Color',mygreen,'interpreter','latex');
text(230,40,mlstring('Share of researchers\\ in the population, $\sigma$'),'Color','b','interpreter','latex');
print Transition4b.eps



diary off;