% oecdhealth  Aug 2009
%
%  See OECDHealthData.xls

if exist('oecdhealth.log'); delete('oecdhealth.log'); end;
diary oecdhealth.log;
fprintf(['oecdhealth                 ' date]);
disp ' ';
disp ' ';
help oecdhealth

%	France	Germany	Japan	United Kingdom	United States
data=[
1960	3.8	NaN	3.0	3.9	5.2
1970	5.4	6.0	4.6	4.5	7.1
1980	7.0	8.4	6.5	5.6	9.0
1990	8.4	8.3	6.0	5.9	12.2
2000	10.1	10.3	7.7	7.0	13.6
2006	11.0	10.5	8.1	8.5	15.8
];

years=data(:,1);
hy=data(:,2:6);

figure(1); figsetup; hold on;
plot(years,hy(:,1),'Color','c'); % France
plot(years,hy(:,2),'m--'); % Germany
plot(years,hy(:,3),'--','Color',mygreen); % Japan
plot(years,hy(:,4),'Color','b'); % UK
plot(years,hy(:,5),'Color','b'); % US
chadfig('Year','Health share of GDP (percent)',1,0);
makefigwide;
text(1985,14,'United States','Color','b');
text(1983,9.2,'Germany','Color','m');
text(2002,11.5,'France','Color','c');
text(2000,6,'U.K.','Color','b');
text(1995,8.2,'Japan','Color',mygreen);
print oecdhealth.eps

diary off;


