function [t,x,chat,hhat,gdpgrowth,vtilde,shat,ellhat,utilde]=solvetransition(ubar,beta,gamma,dlta0,alpha,lambda,phi,rho,nbar,T,tstep,ShowResults)

% Basic routine to solve for transition dynamics of the model.
% See Transition2.m
%
% Show solution if ShowResults==1

    % Steadx state values
    if ShowResults;
      sstar=0
      ellstar=0
      dltastar=0
      zstar=lambda*nbar/(1-phi)
      alp=alpha*lambda/(1-phi)
      ystar=zstar*(gamma+beta*alp)/(gamma+(gamma-1)*alp)
      gs=-alpha*zstar*(gamma-1-beta)/(1+(gamma-1)*(alp+1))
      gc=alpha*zstar*(1+beta*(1+alp))/(1+(gamma-1)*(1+alp))
      gpb=-(1+alpha*beta)*zstar
      blah=alpha*lambda*zstar/(rho+(1-phi+alpha*beta)*zstar);
      sigmastar=blah/(1+blah)
    else;
      sstar=0;
      ellstar=0;
      dltastar=0;
      zstar=lambda*nbar/(1-phi);
      alp=alpha*lambda/(1-phi);
      ystar=zstar*(gamma+beta*alp)/(gamma+(gamma-1)*alp);
      gs=-alpha*zstar*(gamma-1-beta)/(1+(gamma-1)*(alp+1));
      gc=alpha*zstar*(1+beta*(1+alp))/(1+(gamma-1)*(1+alp));
      gpb=-(1+alpha*beta)*zstar;
      blah=alpha*lambda*zstar/(rho+(1-phi+alpha*beta)*zstar);
      sigmastar=blah/(1+blah);
    end;
    
    xstar=[sstar ellstar sigmastar dltastar ystar zstar]';

    tinydev=1e-5;  % s ell sigma dlta y z
    tdv=tinydev; 
    
    sguess=.04;
    ellguess=.05;
    sellguess=[sguess ellguess];
    sell0=getells0(sellguess,dlta0,alpha,beta,lambda,phi,ubar,gamma,rho,zstar,ystar,sigmastar,nbar,gs);
    sstart=sell0(1);
    ellstart=sell0(2);

    xT=[sstart ellstart sigmastar dlta0 ystar-tdv zstar+tdv]';

    % ODE : Do the solving
    tspan=[T:-tstep:0];
    %options = odeset('RelTol',1e-4);
    options = odeset('Stats','off','RelTol',1e-3);
    [t,x] = ode45(@(t,x) transit1dx(t,x,alpha,beta,lambda,phi,ubar,gamma,rho,nbar),tspan,xT,options);
 


    % Recover the key variables
    s=x(:,1);
    ell=x(:,2);
    sigma=x(:,3);
    dlta=x(:,4);
    y=x(:,5);
    z=x(:,6);
    
    % Terms that show up in many equations
    ll=ell./(1-ell);
    sigsig=sigma./(1-sigma);
    ss=s./(1-s);
    B=(dlta.^(-1/beta)./(1-ell)./(1-sigma)).^(1/alpha);
    A=(z./y).^(1/(1-phi)).*ss.^(lambda/(1-phi)).*B;
    c=A.^alpha.*ell.*(1-sigma);
    h=B.^alpha.*(1-ell).*(1-sigma);
    
    utilde=ubar*c.^(gamma-1)+1/(1-gamma);  % u(c)/u'(c)c = value lifeyear / c

    for i=1:length(t);
      dx(:,i)=transit1dx(t(i),x(i,:),alpha,beta,lambda,phi,ubar,gamma,rho,nbar);
    end;
    dx=dx';   % [s ell sigma dlta y z]
    shat=dx(:,1)./s;
    ellhat=dx(:,2)./ell;
    sigmahat=dx(:,3)./sigma;
    dltahat=dx(:,4)./dlta;
    yhat=dx(:,5)./y;
    zhat=dx(:,6)./z;
    chat=alpha*y+ellhat-sigmahat.*sigsig;  
    hhat=alpha*z-ellhat.*ll-sigmahat.*sigsig;  
    gdpgrowth=(1-ell).*hhat+ell.*chat;
    vtilde=1./(beta*ll.*dlta);

    if ShowResults;
      % Show data
      fmt='%6.0f %8.4f %8.4f %8.4f %8.4f %8.4f %8.4f %8.2f %8.2f %8.2f %8.1f %8.1f %8.4f %8.4f';
      cshow(' ',[t x [chat hhat gdpgrowth]*100 vtilde utilde shat ellhat],fmt,'Time s ell sigma dlta gA gB chat hhat gdphat vtilde utilde shat ellhat');

      % Checks on initial values -- for close to SS
      disp ' ';
      disp 'Checks on initial values to ensure we are close to SS:';
      %fprintf('beta*dlta*utilde*ell/(1-ell) at T should be close to rho=%4.2f: %8.6f\n',[rho beta*dlta(1)*utilde(1)*ell(1)/(1-ell(1))]);
      fprintf('gs=%6.4f  shat=%6.4f  ellhat=%6.4f\n',[gs shat(1) ellhat(1)]);
      fprintf('yhat=%6.4f  ystar=%6.4f  zhat=%6.4f  zstar=%6.4f\n',[y(1) ystar z(1) zstar]);
    end;