function dx=transit1dx(t,x,alpha,beta,lambda,phi,ubar,gamma,rho,nbar);

% 3/14/13 -- See 2013-03-14-NumericalSolution.pdf
%
% The system of 6 differential equations for the life & growth model
%
%   x=[s,ell,sigma,dlta,y,z]   y==gA  z==gB

s=x(1);
ell=x(2);
sigma=x(3);
dlta=x(4);
y=x(5);
z=x(6);

bbar=1;
abar=1;

% Terms that show up in many equations
ll=ell./(1-ell);
sigsig=sigma./(1-sigma);
ss=s./(1-s);
B=(dlta.^(-1/beta)./(1-ell)./(1-sigma)).^(1/alpha);
A=(z./y*abar/bbar).^(1/(1-phi)).*ss.^(lambda/(1-phi)).*B;
c=A.^alpha.*ell.*(1-sigma);
utilde=ubar*c.^(gamma-1)+1/(1-gamma);   % u(c)/u'(c)c

% Terms special to ellhat and sigmahat solution
thetaell=(1-ell)./(gamma-(gamma-1-beta).*ell);
Acirc=alpha*beta*z+beta*dlta*utilde.*ll-rho-dlta-(gamma-1)*alpha*y;
omega=(gamma-1-beta)*sigsig;
thetasig=1./(1-lambda+gamma*sigsig);
BBB=rho+dlta+lambda*nbar+(gamma-1)*alpha*y-alpha*lambda*z.*(1-ell)./(1-s)./sigsig;

% Now the differential equations
shat=alpha*lambda/(1-lambda)*z.*(1-ell)./sigsig.*(1-ll./ss.*y./z);
Bcirc=(1-lambda)*shat.*ss+BBB;
ellhat=(thetaell.*Acirc+thetaell.*thetasig.*omega.*Bcirc)./(1-omega.*thetasig*gamma);
sigmahat=thetasig.*(Bcirc+gamma*ellhat);
dltahat=-alpha*beta*z+beta*ellhat.*ll+beta*sigmahat.*sigsig;
yhat=lambda*(nbar+shat+sigmahat)-(1-phi)*y;
zhat=lambda*(nbar-shat.*ss+sigmahat)-(1-phi)*z;

% From growth rates back to changes...
ds=shat.*s;
dell=ellhat.*ell;
dsigma=sigmahat.*sigma;
ddlta=dltahat.*dlta;
dy=yhat.*y;
dz=zhat.*z;

dx=[ds dell dsigma ddlta dy dz]';

%keyboard