% CSHOWhtml.m   []=cshow(names,codes,data,fmt,tle)
%
%  Displays the data in html format for Dashboard.html

function []=cshowhtml(names,codes,data,fmt,tle);

if iscell(names);  % If it's a cell instead of a string.  Convert
  % Create strmat version of names for cshow
  a=names(1);
  for i=2:length(names);
    a=[a '#' names(i)];
  end;
  names=strmat(cell2mat(a),'#');
end;

if exist('tle')~=0;
    if iscell(tle);  % If it's a cell instead of a string.  Convert
        % Create strmat version of names for cshow
        a=tle(1);
        for i=2:length(tle);
            a=[a '#' tle(i)];
        end;
        tle=strmat(cell2mat(a),'#');
    elseif ~isempty(tle);   
        tle=strmat(tle); 
    end; 
else;
  tle=[];
end;


if exist('fmt')==0; fmt='%12.8f'; end;
%if exist('latex')==0;  latex='nonee'; elseif isempty(latex); latex='nonee'; end;
%if exist('nospace')==0; nospace=0; end;


if ~isempty(tle);
  disp ' ';
  ctr=0;
  if names(1,1)~=' '; 
    spc=size(names,2);
    ctr=ctr+spc;
    fprintf(1,['%' num2str(spc) 's'],' '); 
  end;
  blah=strmat(fmt);
  blah=replace(blah,blah=='.','s');
  for i=1:size(tle,1);
    j=size(blah,1);
    if i<j; j=i; end;
    indx=find(blah(j,:)=='s');
    len=str2num(blah(j,2:indx-1));
    ctr=ctr+len;
    indx2=find(tle(i,:)==' ')-1; if isempty(indx2); indx2=length(tle(i,:)); end;
    fprintf(1,['%' num2str(len) 's'],tle(i,1:indx2));
  end;
  fprintf(1,'\n');
  %disp(char(kron('-',ones(1,ctr))));
  disp(char(ones(1,ctr)*'-'));
end;

    % <tr>
    %     <td style="text-align:left"><a href="NYC-ExtendedResults2.pdf">New York City (only)   </a></td>
    %     <td style="text-align:center">2418</td>
    %     <td style="text-align:center">2.71</td>
    %     <td style="text-align:center">1.21</td>
    %     <td style="text-align:center">0.82</td>
    %     <td style="text-align:center">7.09%</td>
    %     <td style="text-align:center">0.63%</td>
    %     <td style="text-align:center">2593</td>
    % </tr>
 



[n k] = size(data);
blah=strmat(fmt);
for i=1:n;
  fprintf('    <tr>\n');
  fprintf('        <td style="text-align:left">');
  fprintf('<<aa href="');
  fprintf(codes{i});
  fprintf('-ExtendedResults2.pdf">');
  fprintf(names(i,:)); 
  fprintf('</a></td>\n');
  for k=1:size(data,2);
    j=size(blah,1);
    if k<j; j=k; end;
    fprintf('        <td style="text-align:center">');
    fprintf(cutspace(blah(j,:)),data(i,k));
    fprintf('</td>\n');
  end;
  fprintf('    </tr>\n');
  disp ' ';
end % i loop

%keyboard



