% calibration_Worker.m
%
%  3/24/17 -- Maximize Worker welfare calibration of simple Saez+Ideas model
%   Local functions in Matlab2017!  Be sure to leave off ";" after "end"
%  8/20/18  -- Updated to fix the missing pareto term.
%  8/23/18  -- the tau version instead of kappa. More intuition.
%  3/25/19  -- managers psi included
%  11/18/20 -- zeta_u = Behavioral Elasticity

if exist('CaseName');
    diarychad(['calibration_Worker_' CaseName]);
else;
    diarychad('calibration_Worker');
end;
ShowParameters

%gamma=[1/8 1/4 1/2 2/3 1]'  % To check gamma=2/3 is flat tax!
for b=1:length(BehaviorElasticities);
    behavior_elas = BehaviorElasticities(b);
    [tau tau0]=solve(gamma,Omega,drho,behavior_elas,s,ell,pareto,rhobar,rho,psi);
    TauSummary(:,b) =tau;
    Tau0Summary(:,b)=tau0;
end;

disp ' ';
disp ' ';
disp '///////////////////////////////////////////////////////////';
disp 'Summary of Key Results for tau (Worker Welfare Case):';
disp '   for different values of zeta_u';
disp '///////////////////////////////////////////////////////////';
tle=['gamma ' num2str(BehaviorElasticities,'%4.1f')];
disp ' ';
disp 'First, the values of the bottom rate tau0:';
cshow(' ',[gamma Tau0Summary],'%6.2f %10.2f',tle,'latex');
disp ' ';
disp 'And the values for the top tax rate tau:';
cshow(' ',[gamma TauSummary],'%6.2f %10.2f',tle,'latex');
disp ' ';
disp ' ';

diary off


function [tau tau0]=solve(gamma,Omega,drho,behavior_elas,s,ell,pareto,rhobar,rho,psi);
    disp ' '; 
    disp '     ==================================================================';
    fprintf('     Top earner behavioral elasticity = %4.2f\n',behavior_elas);
    disp '     ==================================================================';
    zeta_u=behavior_elas; % Old: behavior_elas/(1+behavior_elas);
    eta=(gamma+psi)*zeta_u;
    
    num=1-eta/drho*(1-drho-Omega*(1+rhobar/(1-drho)));
    den=1+pareto*eta+rhobar/(1-drho)*eta;
    tau=num./den;
    tau0=(Omega-drho*tau)/(1-drho);
    kappa=1-tau;
    kappa0=1-tau0;
    %cshow(' ',[gamma tau kappa tau0 kappa0],'%6.2f %10.2f','gamma tau kappa tau0 kappa0','latex');
    cshow(' ',[gamma tau tau0],'%6.2f %10.2f','gamma tau tau0','latex');

    % Check that alternative formula gives the same answer:
    den=1+pareto*eta;
    num=1-eta/drho.*((1-rho)*tau0+(1-drho)*(1-tau0)-Omega);
    tau2=num./den;
    if any(abs(tau-tau2)>1e-13);
      disp 'ERROR: the two formulas give different results??? Stopping...';
      cshow(' ',[gamma tau tau2],'%6.2f %10.2f','gamma tau tau2');
      keyboard
    end; 
end


