function []=chadgraph(xlab,ylab,shrinkfactor,dowait);

% chadgraph.m   3/12/04
%
%   function []=chadgraph(xlab,ylab,shrinkfactor);
%
%  Key:  chadgraph turns off the axis labels, e.g. for xfig like graphs.
%
%  Try to produce very high quality figures that look like those in my
%  growth book.
%
%   xlab=xlabel,  ylab=ylabel.  
%
%  Good ideas for nice figures, to implement before calling:
%
%   xlab=upper(xlab)     %  Upper Case labels
%   set(gca,'LineWidth',1);
%   plot figure with LineWidth=1 as well.
%
%  More ideas:
% $$$ mystr(1)={'\bf IS-Gap'};
% $$$ mystr(2)={'\bf   Curve'};
% $$$ text(10.5,2.5,mystr,'HorizontalAlignment','right');

if exist('shrinkfactor')~=1;
   shrinkfactor=1;
end;
if exist('dowait')~=1;
   dowait=0;
end;


%xlabel(xlab,'FontWeight','Bold','FontSize',14);
%ylabel(ylab,'FontWeight','Bold','FontSize',14,'Rotation',0);
if ~iscell(ylab);
  if ylab(1)~=' ';
    % add spaces if needed to get centered position
    nn=length(ylab);  
    if nn>8; ylab=[ones(1,round(1.4*(nn-8)))*' ' ylab]; end;
  end;
end;

xlabel(xlab,'FontWeight','Bold');
ylabel(ylab,'FontWeight','Bold','Rotation',0);
curaxis=axis;
xstep=curaxis(2)-curaxis(1);
ystep=curaxis(4)-curaxis(3);

set(gca,'Box','off');
xstep=.1*xstep;
ystep=.1*ystep;
axis([curaxis(1)-xstep curaxis(2)+xstep curaxis(3)-ystep curaxis(4)+ystep]);
curaxis=axis;


pos=get(get(gca,'YLabel'),'Position');
pos(2)=curaxis(4);
set(get(gca,'YLabel'),'Position',pos);
set(get(gca,'YLabel'),'HorizontalAlignment','center');
blah=get(gca,'YTick');
set(gca,'YTick',blah);
pos=get(get(gca,'XLabel'),'Position');
pos(1)=curaxis(2);
set(get(gca,'XLabel'),'Position',pos);
set(get(gca,'XLabel'),'HorizontalAlignment','center');


% Shrink the axes to keep labels from being cut off:
% See              The MathWorks MATLAB Digest
%                   June 1995
%              Volume 3, number 6

pos = get(gca,'position'); 		% This is in normalized coordinates
pos(3:4)=pos(3:4)*shrinkfactor; 	% Shrink the axis by a factor of .9
pos(1:2)=pos(1:2)+pos(3:4)*(1-shrinkfactor); % Center it in the figure window
set(gca,'position',pos);


if dowait;
   wait('Adjust any figure settings you want and press Enter');
end;

% Now we turn off the axis labels:
set(gca,'XTick',[]);
set(gca,'YTick',[]);

refresh;

