% convfreq.m   y=convfreq(x,nobs)
%
%    Converts the frequency of a series (matrix) x:
%         quarterly -> annual:  nobs=4
%         monthly   -> quarterly:  nobs=3
%         monthly   -> annual:  nobs=12
%
%    Assumes that the first observations is first quarter or month.

function y=convfreq(x,nobs);

[T N]=size(x);

Tnew=floor(T/nobs);
y=zeros(Tnew,N);

for i=1:Tnew; 		% We'll ignore stragglers at end
  start=(i-1)*nobs+1;
  fin  = start+nobs-1;
  y(i,:)=mean(x(start:fin,:));
end;
