function ydata=interplin(x)

% interplin3
%
%   Simple linear interpolation -- replaces NaNs
%
%    x=initial vector/matrix (will interpolate each column)
%    Column by column


[T K]=size(x);
if T==1; x=x'; T=length(x); end;  % row vector ==> column vector

xdata=x;

for c=1:K;
  x=xdata(:,c);

y=x;
i0=find(~isnan(x));
iT=i0(length(i0)); 			% The last valid position
i0=i0(1); 				% The first valid entry

for i=i0:(iT-1);     % position in x
   if isnan(y(i));
     notnan=find(~isnan(x((i+1):iT)));  % Next non NaN
     notnan=notnan(1)+i;
     points=notnan-i;
     slope=x(notnan)-x(i-1);
     dx=slope/(points+1);
     dx=(1:points)'*dx;
     y(i:(notnan-1))=dx+x(i-1);
   end;
end;

ydata(:,c)=y;
end;
