% SimFigs.m   1/27/06.
%
%  The program Simulations.m saves the simulation results.
%  This program plots the results (run as a separate program
%  in case I need to fiddle with the formatting.  That way we 
%  don't have to rerun the simulations each time.)


clear;
load Simulations;

set(0,'defaultLineLineWidth',1.5);  % Thick lines
set(0,'defaultTextFontSize',16);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Now Plot the Results
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

load HealthData; % Includes a "years" variable.

stopit=0

yrs=(1:find(Years==2050));


% Our 3 main simulations of H/Y.
figure(1); clf;
plot(Years(yrs),HealthShare(yrs,1:4));
hold on;
plot(Years(yrs),HealthShare(yrs,1),'LineWidth',2);  % Baseline darker
plot(years,datahealth,'o','LineWidth',1);
text(2046,.43,'\gamma=2.5');
text(2046,.38,'\gamma=2');
text(2046,.32,'\gamma=1.5');
text(2046,.255,'\gamma=1.01');
text(1975,.06,'Actual');
xlab='Year';
ylab='Health Share, {\it s}';
chadfig(xlab,ylab,1,stopit);
print Simulations1.ps;

% Robustness results for H/Y
figure(2); clf;
plot(Years(yrs),HealthShare(yrs,5:numScen));
hold on;
plot(years,datahealth,'o','LineWidth',1);
text(2045,.42,'VSL=$5m');
bb{1}='Includes Quality'; bb{2}='   of Life (7)';
text(2010,.42,bb);
text(2041,.37,'VSL=$4m (5)');
text(2020,.21,'Faster technical change (8)');
text(2020,.185,' or 50% exogenous (9)');
text(1975,.06,'Actual');
xlab='Year';
ylab='Health Share, {\it s}';
chadfig(xlab,ylab,1,stopit);
print Simulations2.ps;



% All Life Expectancy figures
figure(3); clf;
plot(Years(yrs),LifeExp(yrs,:));
hold on;
plot(years,datalife,'o','LineWidth',1);
text(1975,71,'Actual');
xlab='Year';
ylab='Life Expectancy';
chadfig(xlab,ylab,1,stopit);
print Simulations3.ps;




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Health spending by Age


figure(4); clf;
% Plot the h data by age for 1950 2000 2050
% The particular simulation run we want is saved by Simulations.m
% in the variable "hSim".
plotlog(agecat,hSim(:,[1 11 21])*ydata(2000-1949),'-','400 1000 3000 8000 20000 60000');
hold on;
plot(agecat,log(hdata([1 11],:)*ydata(2000-1949))','o','LineWidth',1);
text(60,log(1050),'1950');
text(80,log(8100),'2000');
text(40,log(40000),'2050');
chadfig('Age','                                      Constant 2000 dollars',1,stopit);
print Simulations4.ps;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  The Theta figures

figure(3); clf;
bar(agecat,ThetaSim,0.5,'g');
hold on;
plot(agecat,ThetaSim+1.96*seSim,'b+','LineWidth',1);
plot(agecat,ThetaSim-1.96*seSim,'b+','LineWidth',1);
for a=1:Nage;
  plot([agecat(a) agecat(a)],[ThetaSim(a)-1.96*seSim(a) ThetaSim(a)+1.96*seSim(a)],'LineWidth',1); 
end;
ax(2)=105; ax(4)=.5; axis(ax);
chadfig('Age',' ',1,0);
print SimsTheta.ps;

% Examples for age groups
figure(4); clf;
hhh=hdata*y2000;
aa=[8 14];  % Age groups 35-39 and 65-69
line(hhh(:,aa(1))',xAlldata(:,aa(1))');
ffig=get(gca,'Parent');
set(ffig,'NextPlot','add');
hold on;
xfit=1./(mAccHom(:,aa(1))'+1./Xfit(aa(1),:));
line(hhh(:,aa(1))',xfit,'Color','g','LineStyle','--');
ax1=gca;
ax=axis; ax(1)=0; ax(2)=.40*y2000; axis(ax);
ylabel('Health status, 35 - 39','FontWeight','Bold');
set(ax1,'XTickLabel',[],'XTick',[]);
ax2 = axes('Position',get(ax1,'Position'),'YAxisLocation','right','Color','none','XColor','k','YColor','k');
line(hhh(:,aa(2))',xAlldata(:,aa(2))','Parent',ax2);
xfit=1./(mAccHom(:,aa(2))'+1./Xfit(aa(2),:));
line(hhh(:,aa(2))',xfit,'Color','g','LineStyle','--','Parent',ax2);
ax=axis; ax(3)=0; ax(4)=12; axis(ax);
%chadfig('Health Input','Health Status',1,0);
xlabel('Health spending (in 2000 dollars)','FontWeight','Bold');
ylabel('Health status, 65 - 69','FontWeight','Bold');
set(gca,'Box','off');
text(.13*y2000,10,mlstring('Age 35 - 39,\\  left scale'));
text(.25*y2000,6.5,mlstring('Age 65 - 69,\\  right scale'));
print SimsXfit.ps;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  The basic H/Y and LifeExp figures
%  Figures 1 and 2 in the paper
%  (copied from readData.m (old)

figure(1); clf;
plot(years,datalife);
xlab='Year';
ylab='Life Expectancy';
chadfig(xlab,ylab,1,stopit);
print LifeData.ps

figure(2); clf;
plot(years,datahealth);
xlab='Year';
ylab='        Health Share';
chadfig(xlab,ylab,1,stopit);
print HealthShare.ps;