function [phi,theta,gTFP,tfp,se,vv,xfit]=estimatetheta(FracFromHz,zgrowth);

% function [phi,theta,gTFP,se,vv]=estimatetheta(FracFromHz,zgrowth);
%
%   2/2/06 -- Rewritten (see getthetaphi.m)
%
%   FracFromHz = what fraction of decline in age-specific mortality
%               is due to hw=wys=tech change + resource effect.
%   
%   Run the regressions to get Production Function for Health using
%   this assumption.
%
%   Uses s/gy+gw/Other accounting.
%                x=A*(tfp*h)^theta, where tfp=z*w.
%           ==>  x=A(zysw)^theta   (zy)=TechChange s=resource w=other
%           Benchmark gz=0 (tech change in health is same as rest of economy)
%
%    se = se of Theta
%    vv = mc of saving a life Nage x Tdata;
%   xfit= fitted values of the production function Nage x Tdata (for Adj)
%
%   Note:  phi=log(A) so A=exp(phi).

global gamma dlta Nage Tsim Tdata N0 gy y y2000 periodlength MaxAge agecat % Inputs
global Phi Theta gTFP gy tfp % Outputs


disp ' '; disp 'estimatetheta.m...';

load HealthData
h=hdata;
x=xAdjdata;       % x=1/mOther -- just the nonaccident mortality


age=(5:5:MaxAge)';
years=(1950:5:2000)';
if exist('zgrowth')~=1; zgrowth=0; end;
gtech=gy+zgrowth

% First, get the age-specific trends in health spending
X=[ones(length(years),1) years];
coeff=inv(X'*X)*X'*log(hdata);
gh=coeff(2,:)';

% Next, get the age-specific trends in inverse mortality
coeff=inv(X'*X)*X'*log(x);
gx=coeff(2,:)';

% Shares of mortality trend explained by health spending
ghz=gh+zgrowth;
gw=(1/FracFromHz-1)*ghz;
gTFP=gw+zgrowth;

gs=gh-gy;
sTech=gtech./(gtech+gs+gw);
ss=gs./(gtech+gs+gw);
seps=gw./(gtech+gs+gw);

disp ' ';
tle='Age xTrend hTrend sTrend gw sh(Tech) sh(s) sh(eps)';
cshow(' ',[age gx gh gs gw sTech ss seps],'%6.0f %8.4f',tle);
disp ' ';
cshow('Average',mean([gx gh gs gw sTech ss seps]),'%8.4f');
disp ' ';

% Prepare for the estimation.
phi=zeros(Nage,1);
theta=zeros(Nage,1);
se=phi;
xfit=zeros(Nage,length(years))*NaN;

tfp=[];
for i=1:Nage;
  tfp=[tfp exp(gTFP(i)*(years-2000))];
end;

W=[ones(length(years),1) years];
instv=strmat('Constant TimeTrend');

diary off;
for i=1:Nage;
   tle=['Log-Log Regression for age: ' num2str(age(i))];
   X=[ones(length(years),1) log(tfp(:,i))+log(h(:,i))];
   indv=strmat('Constant logtfph(a)');
   [u,NN,K,stdest,beta,vcv]=iv(log(x(:,i)),X,W,tle,'log x(a)',indv,instv);
   phi(i)=beta(1);
   theta(i)=beta(2);
   se(i)=sqrt(vcv(2,2));   % standard error for theta
   xfit(i,:)=exp((log(x(:,i))-u))';
   disp ' ';
end;
diary on;


% Age-specific trends in tfp:  tfp(a,t). Redefine to include all
% of Tsim for future program calls.
tfp=[];
for i=1:Nage;
  tfp=[tfp; exp(gTFP(i)*periodlength*((1:Tsim)-Tdata))];  %tfp=1 in 2000.
end;

disp ' '; disp ' '; disp ' ';
disp '**************************************************';
fprintf('*     Share explained by hz trend is %4.2f\n',FracFromHz);
disp '**************************************************';
tle='Age gTFP Phi Theta se(theta) N(a,0)';
cshow(' ',[agecat gTFP phi theta se N0(:,1)],'%5.0f %8.4f %9.3f %8.4f %8.4f %8.4f',tle);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  COMPUTING TECHNOLOGY SIDE VALUE OF LIFE
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Now use these theta's to compute the technology-side value of life.
vtech=div(h.*x,theta');  % for the Cobb-Douglas case
vtech2000=vtech*y2000;   % In year 2000 dollars.

% 1=1950, 6=1975, 11=2000

%  Life expectancy calculation:
%  kVS = vital statistics version, i.e. use year t mortality rates
%  Need to add accidents back in
xall=1./(dlta(:,1:Tdata)+1./x');

m=1./xall;
kVS=zeros(Nage,Tdata);
for a=(Nage-1):(-1):1; 
   kVS(a,:)=(1-m(a,:)).*(kVS(a+1,:)+5); 
end;
% Now compute the average value of life per year of life saved:
vtech2000year=vtech2000./kVS';

disp ' '; disp ' ';
disp 'Value of Life, in thousands 2000 dollars';
disp 'Technology Side:  h*x/theta';
vv=round(vtech2000/10^4)*10^4/10^3;
fmt='%5.1f %7.0f'
tle=['Age ' num2str(1950:10:2000,'%5.0f')];
cshow(' ',[age vv([1 3 5 7 9 11],:)'],fmt,tle);
vv=vv';  % for returning
%vv2000=vv(11,:)'/10^3;  % To be returned as part of the function.

disp ' '; disp ' ';
disp 'Value of Life per Year Saved, in thousands 2000 dollars';
disp 'Technology Side:  h*x/theta / LifeExp';
cshow(' ',[age vtech2000year([1 3 5 7 9 11],:)'/10^3],fmt,tle);

disp ' '; disp ' ';
disp 'Growth rate of VSL, by Age:';
disp ' Age     GrowthRate';
disp '----------------------------------';
gr=1/5*mean(delta(log(vtech2000)));
cshow(' ',[age-2.5 gr'*100],'%6.1f %8.2f');
disp ' ';
fprintf('The overall average growth rate of VSL is %8.4f\n',mean(gr'));


% End of function.

