function []=solvesetup(emptymatrix);

% function []=solvesetup(emptymatrix);    2/1/06
%
%   Does the basic manipulations of the data to prepare for
%   the simulations.  Makes all the key variables global.

global z beta gamma dlta Nage Tsim Tdata N0 y gy y2000 periodlength MaxAge agecat % Created by solvesetup...

load HealthData;
cdata=ydata.*(1-datahealth);
gc=mean(delta(log(cdata)))
gy=mean(delta(log(ydata)))


periodlength=5
Rbar=1.06      % Matching a 6% real interest rate (Euler eqn)
beta1=(1+gc)^gamma/Rbar
beta=beta1^periodlength


MaxAge=100
Nage=MaxAge/periodlength
Tsim=(2100-1950)/periodlength  % E.g. 30
Tdata=11  % 2000
agecat=(1:Nage)'*periodlength;


% Income data -- assume continued growth at past rate
yrs=(1950:periodlength:2000);
y=ydata(yrs-1949)'/ydata(2000-1949);
y=[y exp(gy*periodlength*((12:Tsim)-Tdata))];
y2000=ydata(2000-1949); % In $2000, as opposed to y, which is y=1 in 2000.

% Population -- see MakeData.m for N1950 (age distribution in 1950)
%  and Births19502000.  Also, assume fertility is 4*periodlength=20 million
N0=zeros(Nage,Tsim);
N0(:,1)=N1950; % The 1950 numbers
N0(1,1:11)=Births19502000;
BirthsFuture=4*periodlength
N0(1,12:Tsim)=BirthsFuture;

% Exogenous mortality from accidents/homicides.
% Assume the rate is constant in the future at the 2000 value
% Programming allows for possibility that we might want to allow
% time variation at some point in the future:  dlta(a,t).
%dlta=zeros(Nage,Tsim);
dltafuture=mult(ones(Nage,(Tsim-Tdata)),mAccHom(Tdata,:)');
dlta=[mAccHom' dltafuture];

