/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acmx.export.javax.swing.AWTScrollBar;
import acmx.export.javax.swing.JSliderModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class AWTSlider
extends AWTScrollBar
implements JSliderModel,
AdjustmentListener {
    private static final Color CHANNEL_INSIDE = new Color(0xCCCCCC);
    private static final Color CHANNEL_OUTSIDE = new Color(26316);
    private static final Color SLIDER_COLOR = new Color(0x66CCFF);
    private static final int CHANNEL_HEIGHT = 7;
    private static final int SLIDER_SIZE = 12;
    private ArrayList<ChangeListener> changeListeners;
    private int endSize;

    public AWTSlider(int orientation) {
        super(orientation);
        this.addAdjustmentListener(this);
        this.changeListeners = new ArrayList();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.fireChangeListeners();
    }

    private void fireChangeListeners() {
        ChangeEvent e = new ChangeEvent(this.getParent());
        int nListeners = this.changeListeners.size();
        int i = 0;
        while (i < nListeners) {
            this.changeListeners.get(i).stateChanged(e);
            ++i;
        }
    }

    protected int classifyScrollAction(int x, int y) {
        int pos = 0;
        int length = 0;
        int breadth = 0;
        if (this.getOrientation() == 0) {
            pos = x;
            length = this.getSize().width;
            breadth = this.getSize().height;
        } else {
            pos = y;
            length = this.getSize().height;
            breadth = this.getSize().width;
        }
        int p = (int)(this.getFraction() * (double)(length - breadth) + 0.5);
        if (pos > 0 && pos < p) {
            return 3;
        }
        if (pos >= p && pos <= p + breadth) {
            return 5;
        }
        if (pos > p + breadth && pos < length - breadth) {
            return 4;
        }
        return 0;
    }

    protected int computeDragOffset(int x, int y) {
        int pos = 0;
        int length = 0;
        int breadth = 0;
        if (this.getOrientation() == 0) {
            pos = x;
            length = this.getSize().width;
            breadth = this.getSize().height;
        } else {
            pos = y;
            length = this.getSize().height;
            breadth = this.getSize().width;
        }
        int p = (int)(this.getFraction() * (double)(length - breadth) + 0.5);
        return pos - p;
    }

    protected int computeDragValue(int x, int y) {
        int pos = 0;
        int length = 0;
        int breadth = 0;
        int min = this.getMinimum();
        int max = this.getMaximum();
        if (this.getOrientation() == 0) {
            pos = x;
            length = this.getSize().width;
            breadth = this.getSize().height;
        } else {
            pos = y;
            length = this.getSize().height;
            breadth = this.getSize().width;
        }
        int myValue = min + (int)((double)((pos - this.getDragOffset()) * (max - min) / (length - breadth)) + 0.5);
        return Math.min(Math.max(myValue, min), max);
    }

    protected void drawOuterBorder(Graphics g) {
    }

    protected void drawEndControl(Graphics g, int x, int y, int size, int dir) {
        this.endSize = size;
    }

    protected void drawScrollbarBody(Graphics g, int x, int y, int width, int height) {
        switch (this.getOrientation()) {
            case 0: {
                x -= this.endSize;
                if ((width += 2 * this.endSize) <= height) {
                    return;
                }
                int dx = (int)(this.getFraction() * (double)(width - height) + 0.5);
                dx = Math.max(1, Math.min(dx, width - height - 1));
                g.setColor(CHANNEL_INSIDE);
                g.fillRoundRect(x + 1, y + (height - 7) / 2, width - 4, 7, 7, 7);
                g.setColor(CHANNEL_OUTSIDE);
                g.drawRoundRect(x + 1, y + (height - 7) / 2, width - 4, 7, 7, 7);
                this.drawSlider(g, x + dx, y, height - 2, x + width);
                break;
            }
            case 1: {
                y -= this.endSize;
                if ((height += 2 * this.endSize) <= width) {
                    return;
                }
                int dy = (int)(this.getFraction() * (double)(height - width) + 0.5);
                dy = Math.max(1, Math.min(dy, height - width - 1));
                g.setColor(CHANNEL_INSIDE);
                g.fillRoundRect(x + (width - 7) / 2, y + 1, 7, height - 4, 7, 7);
                g.setColor(CHANNEL_OUTSIDE);
                g.drawRoundRect(x + (width - 7) / 2, y + 1, 7, height - 4, 7, 7);
                this.drawSlider(g, x, y + dy, width - 2, y + height);
            }
        }
    }

    private double getFraction() {
        int value = this.getValue();
        int min = this.getMinimum();
        int max = this.getMaximum();
        return max == min ? 0.0 : (double)(value - min) / (double)(max - min);
    }

    protected void drawSlider(Graphics g, int x, int y, int size, int max) {
        if (max != max) {
            // empty if block
        }
        int xc = x + size / 2;
        int yc = y + size / 2;
        Color color = SLIDER_COLOR;
        g.setColor(color);
        g.fillOval(xc - 6, yc - 6, 12, 12);
        g.setColor(color.darker());
        g.drawOval(xc - 6, yc - 6, 12, 12);
    }
}

