/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.program.GraphicsProgram;
import java.awt.Color;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class Artistry
extends GraphicsProgram {
    public static Calendar calendar = GregorianCalendar.getInstance();
    Date date = calendar.getTime();
    long time = this.date.getTime();
    private static final int MS_IN_SECOND = 1000;
    private static final int MS_IN_MINUTE = 60000;
    private static final int MS_IN_HOUR = 3600000;
    private static final int TIME_ZONE_ERROR = -2;
    private int seconds = (int)(this.time / 1000L);
    private int minutes = (int)(this.time / 60000L);
    private int hours = (int)(this.time / 3600000L) + -2;
    private double X_CENTER;
    private double Y_CENTER;
    private static final double BODY_RADIUS = 200.0;
    private static final double SECOND_HAND_RATIO = 1.2;
    private static final double MINUTE_HAND_RATIO = 1.5;
    private static final double HOUR_HAND_RATIO = 2.4;
    private static final double NUMBER_RATIO = 1.07;

    public void run() {
        this.drawBody();
        this.addSignature();
        double d = this.minutes;
        while (true) {
            GLine gLine = this.polarLine(0.0, 2.4, ((double)this.hours + (d += 1.0) / 60.0) / 6.0);
            this.add((GObject)gLine);
            GLine gLine2 = this.polarLine(0.0, 1.5, d / 30.0);
            this.add((GObject)gLine2);
            for (double d2 = (double)this.seconds; d2 < (double)(this.seconds + 60); d2 += 1.0) {
                GLine gLine3 = this.polarLine(0.0, 1.2, d2 / 30.0);
                this.add((GObject)gLine3);
                this.pause(1000.0);
                this.remove((GObject)gLine3);
            }
            this.remove((GObject)gLine2);
            this.remove((GObject)gLine);
        }
    }

    private void drawBody() {
        double d = (double)(this.getWidth() / 2) - 200.0;
        double d2 = (double)(this.getHeight() / 2) - 200.0;
        this.X_CENTER = d + 200.0;
        this.Y_CENTER = d2 + 200.0;
        GOval gOval = new GOval(d, d2, 400.0, 400.0);
        gOval.setFilled(true);
        gOval.setFillColor(Color.orange);
        this.add((GObject)gOval);
        this.drawNumbers();
    }

    private void drawNumbers() {
        for (int i = 1; i <= 12; ++i) {
            GLabel gLabel = new GLabel("" + i);
            gLabel.setFont("Times-20");
            gLabel.setColor(Color.red);
            double d = 1.5707963267948966 - Math.PI * ((double)i / 6.0);
            double d2 = this.X_CENTER + 186.91588785046727 * Math.cos(d);
            double d3 = this.Y_CENTER - 186.91588785046727 * Math.sin(d);
            double d4 = d2 - gLabel.getWidth() / 2.0;
            double d5 = d3 + gLabel.getAscent() / 2.0;
            gLabel.setLocation(d4, d5);
            this.add((GObject)gLabel);
        }
    }

    private void addSignature() {
        GLabel gLabel = new GLabel("Artistry by Arun Debray");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getDescent();
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }

    private GLine polarLine(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6 = 1.5707963267948966 - Math.PI * d3;
        if (d == 0.0) {
            d5 = this.X_CENTER;
            d4 = this.Y_CENTER;
        } else {
            d5 = this.X_CENTER + 200.0 / d * Math.cos(d6);
            d4 = this.Y_CENTER - 200.0 / d * Math.sin(d6);
        }
        double d7 = this.X_CENTER + 200.0 / d2 * Math.cos(d6);
        double d8 = this.Y_CENTER - 200.0 / d2 * Math.sin(d6);
        GLine gLine = new GLine(d5, d4, d7, d8);
        return gLine;
    }
}

