/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double BACKGROUND_RADIUS = 500.0;
    private static final double HEAD_RADIUS = 100.0;
    private static final double EAR_RADIUS = 65.0;
    private static final double EYE_RADIUS = 20.0;
    private static final double EYE_SPACING = 65.0;
    private static final double EYE_Y = 15.0;
    private static final double PUPIL_SPACING = 120.0;
    private static final double PUPIL_Y = 30.0;
    private static final double PUPIL_RADIUS = 5.0;
    private static final double SNOUT_RADIUS = 35.0;
    private static final double SNOUT_Y = 29.0;
    private static final double NOSE_RADIUS = 5.0;
    private static final double NOSE_Y = 40.0;
    private static final double MOUTH_LENGTH = 30.0;
    private static final double MOUTH_Y = 60.0;
    private static final double TOOTH_WIDTH = 10.0;
    private static final double TOOTH_Y = 61.0;
    private static final double TOOTH_LENGTH = 17.0;
    private static final double GAP_WIDTH = 4.0;

    public void run() {
        double d = this.getWidth() / 2;
        double d2 = this.getHeight() / 2;
        this.drawBackground(d, d2);
        this.drawHead(d - 100.0, d2 - 100.0);
        this.drawEar(d - 165.0, d2 - 165.0);
        this.drawEar(d + 35.0, d2 - 165.0);
        this.drawEye(d - 72.5, d2 + 15.0);
        this.drawEye(d + 32.5, d2 + 15.0);
        this.drawPupil(d - 70.0, d2 + 30.0);
        this.drawPupil(d + 60.0, d2 + 30.0);
        this.drawSnout(d - 35.0, d2 + 29.0);
        this.drawNose(d - 5.0, d2 + 40.0);
        this.drawMouth(d - 15.0, d2 + 60.0, d + 15.0, d2 + 60.0);
        this.drawTooth(d - 12.0, d2 + 61.0);
        this.drawTooth(d + 2.0, d2 + 61.0);
        this.addPhrase();
        this.addName();
    }

    private void drawBackground(double d, double d2) {
        this.drawStripe(d, d2, 500.0, Color.CYAN);
        this.drawStripe(d, d2, 450.0, Color.MAGENTA);
        this.drawStripe(d, d2, 350.0, Color.GREEN);
        this.drawStripe(d, d2, 250.0, Color.CYAN);
        this.drawStripe(d, d2, 150.0, Color.YELLOW);
    }

    private void drawStripe(double d, double d2, double d3, Color color) {
        double d4 = d - d3;
        double d5 = d2 - d3;
        GOval gOval = new GOval(2.0 * d3, 2.0 * d3);
        gOval.setFilled(true);
        gOval.setColor(color);
        this.add((GObject)gOval, d4, d5);
    }

    private void drawHead(double d, double d2) {
        this.drawCircle(d, d2, 100.0, Color.BLACK);
    }

    private void drawEar(double d, double d2) {
        this.drawCircle(d, d2, 65.0, Color.BLACK);
    }

    private void drawEye(double d, double d2) {
        this.drawCircle(d, d2, 20.0, Color.WHITE);
    }

    private void drawPupil(double d, double d2) {
        this.drawCircle(d, d2, 5.0, Color.BLACK);
    }

    private void drawSnout(double d, double d2) {
        this.drawCircle(d, d2, 35.0, Color.LIGHT_GRAY);
    }

    private void drawNose(double d, double d2) {
        this.drawCircle(d, d2, 5.0, Color.YELLOW);
    }

    private void drawTooth(double d, double d2) {
        GRect gRect = new GRect(d, d2, 10.0, 17.0);
        gRect.setFilled(true);
        gRect.setColor(Color.WHITE);
        this.add((GObject)gRect);
    }

    private void drawCircle(double d, double d2, double d3, Color color) {
        GOval gOval = new GOval(d, d2, 2.0 * d3, 2.0 * d3);
        gOval.setFilled(true);
        gOval.setColor(color);
        this.add((GObject)gOval);
    }

    private void drawMouth(double d, double d2, double d3, double d4) {
        GLine gLine = new GLine(d, d2, d3, d4);
        this.add((GObject)gLine);
    }

    private void addPhrase() {
        GLabel gLabel = new GLabel("MICKEY IS WATCHING YOU.");
        gLabel.setFont("SansSerif-50");
        gLabel.setColor(Color.RED);
        double d = ((double)this.getWidth() - gLabel.getWidth()) / 2.0;
        double d2 = (this.getHeight() + 350) / 2;
        this.add((GObject)gLabel, d, d2);
    }

    private void addName() {
        GLabel gLabel = new GLabel("Artistry by Alex Kim");
        gLabel.setFont("Times-16");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getAscent();
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }
}

