/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPolygon;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static double HOUSE_WIDTH = 200.0;
    private static double HOUSE_HEIGHT = 200.0;
    private static double WINDOW_WIDTH = 40.0;
    private static double WINDOW_HEIGHT = 40.0;
    private static double DOOR_WIDTH = 60.0;
    private static double DOOR_HEIGHT = 100.0;
    private static double ROOF_HEIGHT = 130.0;
    private static double NAME_X_LOCATION = 5.0;
    private static double NAME_Y_LOCATION = 5.0;

    public void run() {
        double d = ((double)this.getWidth() - HOUSE_WIDTH) / 2.0;
        double d2 = ((double)this.getHeight() - HOUSE_HEIGHT) / 2.0;
        this.drawHouseStructure(d, d2);
        double d3 = d + 0.25 * HOUSE_WIDTH - WINDOW_WIDTH / 2.0;
        double d4 = d2 + 0.25 * HOUSE_HEIGHT - WINDOW_HEIGHT / 2.0;
        this.drawLeftWindow(d3, d4);
        double d5 = d + 0.75 * HOUSE_WIDTH - WINDOW_WIDTH / 2.0;
        this.drawRightWindow(d5, d4);
        double d6 = d + 0.5 * HOUSE_HEIGHT - DOOR_WIDTH / 2.0;
        double d7 = d2 + HOUSE_HEIGHT - DOOR_HEIGHT;
        this.drawDoor(d6, d7);
        this.drawRoof(d, d2);
        double d8 = NAME_X_LOCATION;
        double d9 = NAME_Y_LOCATION;
        this.drawHeading(d, d2);
        this.drawName(d8, d9);
    }

    private void drawHouseStructure(double d, double d2) {
        GRect gRect = new GRect(d, d2, HOUSE_WIDTH, HOUSE_HEIGHT);
        gRect.setFilled(false);
        this.add((GObject)gRect);
    }

    private void drawLeftWindow(double d, double d2) {
        GOval gOval = new GOval(d, d2, WINDOW_WIDTH, WINDOW_HEIGHT);
        gOval.setFilled(true);
        gOval.setColor(Color.YELLOW);
        this.add((GObject)gOval);
    }

    private void drawRightWindow(double d, double d2) {
        GOval gOval = new GOval(d, d2, WINDOW_WIDTH, WINDOW_HEIGHT);
        gOval.setFilled(true);
        gOval.setColor(Color.YELLOW);
        this.add((GObject)gOval);
    }

    private void drawDoor(double d, double d2) {
        GRect gRect = new GRect(d, d2, DOOR_WIDTH, DOOR_HEIGHT);
        gRect.setFilled(true);
        gRect.setColor(Color.BLUE);
        this.add((GObject)gRect);
    }

    private void drawRoof(double d, double d2) {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(d + 0.5 * HOUSE_WIDTH, d2 - ROOF_HEIGHT);
        gPolygon.addVertex(d, d2);
        gPolygon.addVertex(d + HOUSE_WIDTH, d2);
        gPolygon.setFilled(true);
        gPolygon.setColor(Color.RED);
        this.add((GObject)gPolygon);
    }

    private void drawHeading(double d, double d2) {
        GLabel gLabel = new GLabel("Welcome Home!", d / 4.0, d2 / 4.0);
        gLabel.setFont("Apple Casual-30");
        gLabel.setColor(Color.GREEN);
        this.add((GObject)gLabel);
    }

    private void drawName(double d, double d2) {
        GLabel gLabel = new GLabel("Artistry by Amanda Mener", d, d2);
        gLabel.setFont("Apple Casual-20");
        gLabel.setColor(Color.ORANGE);
        this.add((GObject)gLabel);
        gLabel.getWidth();
        gLabel.getHeight();
        d = (double)this.getWidth() - gLabel.getWidth();
        d2 = (double)this.getHeight() - gLabel.getDescent();
        gLabel.setLocation(d, d2);
    }
}

