/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GArc;
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.program.GraphicsProgram;
import acm.util.RandomGenerator;

public class Artistry
extends GraphicsProgram {
    private static final int NUMBER_OF_SIDES = 5;
    private static final int SIDE_LENGTH = 170;
    private static final int NUMBER_OF_DIAGONALS = 2;
    private static final double EXTERIOR_ANGLE_RADIANS = 1.8849555921538759;
    private static final double INTERIOR_ANGLE_RADIANS = 1.2566370614359172;
    private static final double HEIGHT = 170.0 * Math.sin(0.9424777960769379) / Math.sin(1.2566370614359172);
    private static final double INTERIOR_SIDE_LENGTH = 340.0 * (Math.sin(0.9424777960769379) - Math.sin(0.6283185307179586) / Math.sin(1.8849555921538759));
    private static final double INTERIOR_HEIGHT = INTERIOR_SIDE_LENGTH / 2.0 / Math.tan(0.6283185307179586);
    private RandomGenerator rgen = RandomGenerator.getInstance();

    public void run() {
        this.artistryString();
        this.addTitleString(this.getWidth() / 2, this.getHeight() / 5, "WHAT TIME IS IT...?");
        this.loadingArc();
        double d = 0.0;
        while (true) {
            this.removeAll();
            this.artistryString();
            this.addTitleString(this.getWidth() / 2, this.getHeight() / 8, "PARTY TIME!");
            GOval gOval = new GOval((double)(this.getWidth() / 2) - HEIGHT, (double)(this.getHeight() / 2) - HEIGHT, 2.0 * HEIGHT, 2.0 * HEIGHT);
            this.add((GObject)gOval);
            this.addRotatingStar(d);
            this.addInnerCircle();
            this.pause(25.0);
            d += 0.04908738521234052;
        }
    }

    private void artistryString() {
        GLabel gLabel = new GLabel("Artistry by Arjun Mathur!");
        this.add((GObject)gLabel, (double)this.getWidth() - gLabel.getWidth(), (double)this.getHeight() - gLabel.getDescent());
    }

    private void addTitleString(double d, double d2, String string) {
        GLabel gLabel = new GLabel(string);
        gLabel.setFont("Calibri-bold-50");
        this.add((GObject)gLabel, d -= gLabel.getWidth() / 2.0, d2 -= gLabel.getDescent());
    }

    private void loadingArc() {
        for (int i = 0; i < 360; i += 5) {
            GArc gArc = new GArc((double)(this.getWidth() / 2 - 50), (double)(this.getHeight() / 2 - 50), 100.0, 100.0, 0.0, (double)i);
            gArc.setFilled(true);
            this.add((GObject)gArc);
            this.pause(40.0);
        }
    }

    private void addRotatingStar(double d) {
        for (int i = 0; i < 5; ++i) {
            double d2 = (double)(this.getWidth() / 2) + HEIGHT * Math.sin((double)i * 1.2566370614359172 + d);
            double d3 = (double)(this.getHeight() / 2) - HEIGHT * Math.cos((double)i * 1.2566370614359172 + d);
            double d4 = (double)(this.getWidth() / 2) + HEIGHT * Math.sin((double)(i + 1) * 1.2566370614359172 + d);
            double d5 = (double)(this.getHeight() / 2) - HEIGHT * Math.cos((double)(i + 1) * 1.2566370614359172 + d);
            this.drawLine(d2, d3, d4, d5);
            double d6 = (double)(this.getWidth() / 2) + HEIGHT * Math.sin((double)(i + 2) * 1.2566370614359172 + d);
            double d7 = (double)(this.getHeight() / 2) - HEIGHT * Math.cos((double)(i + 2) * 1.2566370614359172 + d);
            this.drawDiagonals(d2, d3, d4, d5, d6, d7);
        }
    }

    private void drawLine(double d, double d2, double d3, double d4) {
        GLine gLine = new GLine(d, d2, d3, d4);
        gLine.setColor(this.rgen.nextColor());
        this.add((GObject)gLine);
    }

    private void drawDiagonals(double d, double d2, double d3, double d4, double d5, double d6) {
        for (int i = 1; i <= 2; ++i) {
            double d7 = (d5 - d3) / 2.0;
            double d8 = (d6 - d4) / 2.0;
            this.drawLine(d, d2, d3 + (double)i * d7, d4 + (double)i * d8);
        }
    }

    private void addInnerCircle() {
        GOval gOval = new GOval((double)(this.getWidth() / 2) - INTERIOR_HEIGHT, (double)(this.getHeight() / 2) - INTERIOR_HEIGHT, 2.0 * INTERIOR_HEIGHT, 2.0 * INTERIOR_HEIGHT);
        gOval.setFilled(true);
        gOval.setColor(this.rgen.nextColor());
        gOval.setFillColor(null);
        this.add((GObject)gOval);
    }
}

