/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPolygon;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final Color SKY_BLUE = new Color(166, 200, 255);
    private static final Color LAKE_BLUE = new Color(155, 175, 188);
    private static final Color MOUNTAIN1 = new Color(156, 178, 180);
    private static final Color MOUNTAIN1_REF = new Color(145, 165, 164);
    private static final Color MOUNTAIN2 = new Color(146, 166, 160);
    private static final Color MOUNTAIN2_REF = new Color(140, 158, 150);
    private static final Color SNOW1 = new Color(198, 210, 211);
    private static final Color SNOW1_REF = new Color(191, 202, 202);
    private static final Color SNOW2 = new Color(201, 214, 210);
    private static final Color SNOW2_REF = new Color(188, 199, 194);
    private static final Color PALE_YELLOW = new Color(227, 226, 162);
    private static final Color OFF_WHITE = new Color(198, 210, 211);
    private static final Color OFF_RED = new Color(226, 44, 42);

    public void run() {
        this.drawSky();
        this.drawMountains();
        this.drawLake();
        this.drawSun();
        this.drawReflections();
        this.drawDecoration();
        this.addSignature();
    }

    private void drawSky() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        GRect gRect = new GRect(0.0, 0.0, (double)n, (double)n2);
        gRect.setFilled(true);
        gRect.setColor(SKY_BLUE);
        gRect.setFillColor(SKY_BLUE);
        this.add((GObject)gRect);
    }

    private void drawSun() {
        int n = 70;
        GOval gOval = new GOval(200.0, 50.0, (double)n, (double)n);
        gOval.setFilled(true);
        gOval.setFillColor(PALE_YELLOW);
        gOval.setColor(PALE_YELLOW);
        this.add((GObject)gOval);
    }

    private void drawLake() {
        int n = (int)((double)this.getHeight() * 0.6666666666666666);
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        GRect gRect = new GRect(0.0, (double)n, (double)n2, (double)n3);
        gRect.setFilled(true);
        gRect.setFillColor(LAKE_BLUE);
        gRect.setColor(LAKE_BLUE);
        this.add((GObject)gRect);
    }

    private void drawMountains() {
        this.drawMountainLeft();
        this.drawMountainRight();
    }

    private void drawMountainLeft() {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(0.0, 78.0);
        gPolygon.addEdge(6.0, 6.0);
        gPolygon.addEdge(18.0, -4.0);
        gPolygon.addVertex(96.0, 33.0);
        gPolygon.addEdge(24.0, 24.0);
        gPolygon.addEdge(4.0, 30.0);
        gPolygon.addVertex(180.0, 153.0);
        gPolygon.addEdge(48.0, 36.0);
        gPolygon.addEdge(42.0, 54.0);
        gPolygon.addVertex(300.0, 250.0);
        gPolygon.addEdge(0.0, 60.0);
        gPolygon.addVertex(0.0, 310.0);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(MOUNTAIN1);
        gPolygon.setColor(MOUNTAIN1);
        this.add((GObject)gPolygon);
        this.drawSnowLeft();
    }

    private void drawMountainRight() {
        int n = (int)((double)this.getHeight() * 0.6666666666666666);
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex((double)this.getWidth(), 11.0);
        gPolygon.addEdge(-42.0, -24.0);
        gPolygon.addVertex((double)(this.getWidth() - 55), 25.0);
        gPolygon.addEdge(-66.0, 48.0);
        gPolygon.addEdge(-39.0, 30.0);
        gPolygon.addEdge(-36.0, 42.0);
        gPolygon.addVertex((double)(this.getWidth() - 274), 180.0);
        gPolygon.addVertex(402.0, 138.0);
        gPolygon.addEdge(-66.0, 24.0);
        gPolygon.addEdge(-21.0, 24.0);
        gPolygon.addEdge(-114.0, 69.0);
        gPolygon.addEdge(-78.0, 30.0);
        gPolygon.addVertex(48.0, (double)n);
        gPolygon.addVertex(60.0, 360.0);
        gPolygon.addVertex((double)this.getWidth(), 360.0);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(MOUNTAIN2);
        gPolygon.setColor(MOUNTAIN2);
        this.add((GObject)gPolygon);
        this.drawSnowCenter();
        this.drawSnowRight();
    }

    private void drawSnowLeft() {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(0.0, 78.0);
        gPolygon.addEdge(6.0, 6.0);
        gPolygon.addEdge(18.0, -4.0);
        gPolygon.addVertex(96.0, 33.0);
        gPolygon.addEdge(24.0, 24.0);
        gPolygon.addEdge(4.0, 30.0);
        gPolygon.addVertex(180.0, 153.0);
        gPolygon.addEdge(54.0, 40.0);
        gPolygon.addEdge(-30.0, -18.0);
        gPolygon.addEdge(-36.0, -3.0);
        gPolygon.addEdge(-30.0, 3.0);
        gPolygon.addVertex(108.0, 174.0);
        gPolygon.addEdge(18.0, -21.0);
        gPolygon.addEdge(-42.0, -24.0);
        gPolygon.addEdge(-3.0, -18.0);
        gPolygon.addEdge(12.0, -6.0);
        gPolygon.addVertex(63.0, 90.0);
        gPolygon.addEdge(-24.0, 18.0);
        gPolygon.addVertex(0.0, 114.0);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(SNOW1);
        gPolygon.setColor(SNOW1);
        this.add((GObject)gPolygon);
    }

    private void drawSnowCenter() {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex((double)(this.getWidth() - 274), 180.0);
        gPolygon.addVertex(402.0, 138.0);
        gPolygon.addEdge(-66.0, 24.0);
        gPolygon.addEdge(-21.0, 24.0);
        gPolygon.addEdge(-20.0, 12.0);
        gPolygon.addEdge(12.0, 3.0);
        gPolygon.addVertex(384.0, 168.0);
        gPolygon.addEdge(24.0, 18.0);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(SNOW2);
        gPolygon.setColor(SNOW2);
        this.add((GObject)gPolygon);
    }

    private void drawSnowRight() {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex((double)this.getWidth(), 11.0);
        gPolygon.addEdge(-42.0, -24.0);
        gPolygon.addVertex((double)(this.getWidth() - 55), 25.0);
        gPolygon.addEdge(-66.0, 48.0);
        gPolygon.addEdge(-39.0, 30.0);
        gPolygon.addEdge(-36.0, 42.0);
        gPolygon.addVertex((double)(this.getWidth() - 274), 180.0);
        gPolygon.addEdge(40.0, -6.0);
        gPolygon.addEdge(40.0, -20.0);
        gPolygon.addEdge(3.0, 8.0);
        gPolygon.addVertex(570.0, 150.0);
        gPolygon.addEdge(54.0, -30.0);
        gPolygon.addEdge(36.0, 6.0);
        gPolygon.addEdge(3.0, 6.0);
        gPolygon.addVertex(696.0, 162.0);
        gPolygon.addEdge(15.0, -42.0);
        gPolygon.addVertex((double)this.getWidth(), 129.0);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(SNOW2);
        gPolygon.setColor(SNOW2);
        this.add((GObject)gPolygon);
    }

    private void drawReflections() {
        this.drawMountainLReflect();
        this.drawMountainRReflect();
    }

    private void drawMountainLReflect() {
        int n = (int)((double)this.getHeight() * 0.6666666666666666);
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(0.0, (double)(n - 78 + n));
        gPolygon.addEdge(6.0, -6.0);
        gPolygon.addEdge(18.0, 4.0);
        gPolygon.addVertex(96.0, (double)(n - 33 + n));
        gPolygon.addEdge(24.0, -24.0);
        gPolygon.addEdge(4.0, -30.0);
        gPolygon.addVertex(180.0, (double)(n - 153 + n));
        gPolygon.addEdge(48.0, -36.0);
        gPolygon.addEdge(42.0, -54.0);
        gPolygon.addVertex(300.0, (double)(n - 250 + n));
        gPolygon.addEdge(0.0, -60.0);
        gPolygon.addVertex(0.0, 311.0);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(MOUNTAIN1_REF);
        gPolygon.setColor(MOUNTAIN1_REF);
        this.add((GObject)gPolygon);
        this.drawSnowLReflect();
    }

    private void drawMountainRReflect() {
        int n = (int)((double)this.getHeight() * 0.6666666666666666);
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex((double)this.getWidth(), (double)(n - 11 + n));
        gPolygon.addEdge(-42.0, 24.0);
        gPolygon.addVertex((double)(this.getWidth() - 55), (double)(n - 25 + n));
        gPolygon.addEdge(-66.0, -48.0);
        gPolygon.addEdge(-39.0, -30.0);
        gPolygon.addEdge(-36.0, -42.0);
        gPolygon.addVertex((double)(this.getWidth() - 274), (double)(n - 180 + n));
        gPolygon.addVertex(402.0, (double)(n - 138 + n));
        gPolygon.addEdge(-66.0, -24.0);
        gPolygon.addEdge(-21.0, -24.0);
        gPolygon.addEdge(-114.0, -69.0);
        gPolygon.addEdge(-78.0, -30.0);
        gPolygon.addVertex(48.0, (double)n);
        gPolygon.addVertex(60.0, (double)n);
        gPolygon.addVertex((double)this.getWidth(), (double)n);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(MOUNTAIN2_REF);
        gPolygon.setColor(MOUNTAIN2_REF);
        this.add((GObject)gPolygon);
        this.drawSnowCReflect();
        this.drawSnowRReflect();
    }

    private void drawSnowLReflect() {
        int n = (int)((double)this.getHeight() * 0.6666666666666666);
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(0.0, (double)(n - 78 + n));
        gPolygon.addEdge(6.0, -6.0);
        gPolygon.addEdge(18.0, 4.0);
        gPolygon.addVertex(96.0, (double)(n - 33 + n));
        gPolygon.addEdge(24.0, -24.0);
        gPolygon.addEdge(4.0, -30.0);
        gPolygon.addVertex(180.0, (double)(n - 153 + n));
        gPolygon.addEdge(54.0, -40.0);
        gPolygon.addEdge(-30.0, 18.0);
        gPolygon.addEdge(-36.0, 3.0);
        gPolygon.addEdge(-30.0, -3.0);
        gPolygon.addVertex(108.0, (double)(n - 174 + n));
        gPolygon.addEdge(18.0, 21.0);
        gPolygon.addEdge(-42.0, 24.0);
        gPolygon.addEdge(-3.0, 18.0);
        gPolygon.addEdge(12.0, 6.0);
        gPolygon.addVertex(63.0, (double)(n - 90 + n));
        gPolygon.addEdge(-24.0, -18.0);
        gPolygon.addVertex(0.0, (double)(n - 114 + n));
        gPolygon.setFilled(true);
        gPolygon.setFillColor(SNOW1_REF);
        gPolygon.setColor(SNOW1_REF);
        this.add((GObject)gPolygon);
    }

    private void drawSnowCReflect() {
        int n = (int)((double)this.getHeight() * 0.6666666666666666);
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex((double)(this.getWidth() - 274), (double)(n - 180 + n));
        gPolygon.addVertex(402.0, (double)(n - 138 + n));
        gPolygon.addEdge(-66.0, -24.0);
        gPolygon.addEdge(-21.0, -24.0);
        gPolygon.addEdge(-20.0, -12.0);
        gPolygon.addEdge(12.0, -3.0);
        gPolygon.addVertex(384.0, (double)(n - 168 + n));
        gPolygon.addEdge(24.0, -18.0);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(SNOW2_REF);
        gPolygon.setColor(SNOW2_REF);
        this.add((GObject)gPolygon);
    }

    private void drawSnowRReflect() {
        int n = (int)((double)this.getHeight() * 0.6666666666666666);
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex((double)this.getWidth(), (double)(n - 11 + n));
        gPolygon.addEdge(-42.0, 24.0);
        gPolygon.addVertex((double)(this.getWidth() - 55), (double)(n - 25 + n));
        gPolygon.addEdge(-66.0, -48.0);
        gPolygon.addEdge(-39.0, -30.0);
        gPolygon.addEdge(-36.0, -42.0);
        gPolygon.addVertex((double)(this.getWidth() - 274), (double)(n - 180 + n));
        gPolygon.addEdge(40.0, 6.0);
        gPolygon.addEdge(40.0, 20.0);
        gPolygon.addEdge(3.0, -8.0);
        gPolygon.addVertex(570.0, (double)(n - 150 + n));
        gPolygon.addEdge(54.0, 30.0);
        gPolygon.addEdge(36.0, -6.0);
        gPolygon.addEdge(3.0, -6.0);
        gPolygon.addVertex(696.0, (double)(n - 162 + n));
        gPolygon.addEdge(15.0, 42.0);
        gPolygon.addVertex((double)this.getWidth(), (double)(n - 129 + n));
        gPolygon.setFilled(true);
        gPolygon.setFillColor(SNOW2_REF);
        gPolygon.setColor(SNOW2_REF);
        this.add((GObject)gPolygon);
    }

    private void drawDecoration() {
        int n = (int)((double)this.getHeight() * 0.6666666666666666);
        int n2 = this.getWidth();
        int n3 = 20;
        GRect gRect = new GRect(0.0, (double)(n - n3 / 2), (double)n2, (double)n3);
        gRect.setFilled(true);
        gRect.setFillColor(OFF_WHITE);
        gRect.setColor(OFF_WHITE);
        this.add((GObject)gRect);
        this.drawSwissFlag();
    }

    private void drawSwissFlag() {
        int n = (int)((double)this.getHeight() * 0.6666666666666666);
        int n2 = 32;
        int n3 = 32;
        GRect gRect = new GRect(540.0, (double)(n - n3 / 2), (double)n2, (double)n3);
        gRect.setFilled(true);
        gRect.setFillColor(OFF_RED);
        gRect.setColor(OFF_RED);
        int n4 = 8;
        int n5 = 26;
        GRect gRect2 = new GRect(543.0, (double)(n - n3 / 2 + 12), (double)n5, (double)n4);
        GRect gRect3 = new GRect(552.0, (double)(n - n3 / 2 + 3), (double)n4, (double)n5);
        gRect2.setFilled(true);
        gRect2.setFillColor(OFF_WHITE);
        gRect2.setColor(OFF_WHITE);
        gRect3.setFilled(true);
        gRect3.setFillColor(OFF_WHITE);
        gRect3.setColor(OFF_WHITE);
        this.add((GObject)gRect);
        this.add((GObject)gRect2);
        this.add((GObject)gRect3);
    }

    private void addSignature() {
        GLabel gLabel = new GLabel("by Diana Barthauer", 0.0, (double)(this.getHeight() - 5));
        gLabel.setFont("Helvetica-12");
        gLabel.setColor(PALE_YELLOW);
        this.add((GObject)gLabel);
    }
}

