/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final Color SKY = new Color(30, 150, 255);
    private static final Color TAN = new Color(238, 197, 145);
    private static final Color RED_ROOF = new Color(128, 0, 0);
    private static final double LARGE_TOWER_HEIGHT = 250.0;
    private static final double LARGE_TOWER_WIDTH = 80.0;
    private static final double MEDIUM_TOWER_HEIGHT = 65.0;
    private static final double MEDIUM_TOWER_WIDTH = 60.0;
    private static final double SMALL_TOWER_HEIGHT = 15.0;
    private static final double SMALL_TOWER_WIDTH = 10.0;
    private static final double FIRST_DOME_Y_COORDINATE = 345.0;
    private static final double SECOND_DOME_Y_COORDINATE = 365.0;
    private static final double FINAL_TOWER_Y_COORDINATE = 360.0;
    private static final double WINDOW_HEIGHT_RATIO = 0.7142857142857143;
    private static final double WINDOW_ARCH_Y_COORDINATE = 302.42857142857144;
    private static final double WINDOW_RECT_Y_COORDINATE = 296.42857142857144;
    private static final double RIGHT_WINDOW_X_COORDINATE = 12.0;

    public void run() {
        this.paintSky();
        this.makeSun();
        this.buildCore();
        this.buildWindows();
        this.buildAccents();
        this.addSignature();
    }

    private void paintSky() {
        GRect gRect = new GRect(0.0, 0.0, (double)this.getWidth(), (double)this.getHeight());
        gRect.setFilled(true);
        gRect.setFillColor(SKY);
        this.add((GObject)gRect);
    }

    private void makeSun() {
        GOval gOval = new GOval((double)(this.getWidth() - 130), (double)(this.getHeight() - 440), 70.0, 70.0);
        gOval.setFilled(true);
        gOval.setFillColor(Color.YELLOW);
        this.add((GObject)gOval);
    }

    private void buildCore() {
        double d = this.getHeight();
        this.buildTower(80.0, d - 250.0, 250.0, TAN);
        this.buildDome(60.0, d - 345.0, RED_ROOF);
        this.buildTower(60.0, d - 65.0 - 250.0, 65.0, TAN);
        this.buildDome(10.0, d - 365.0, RED_ROOF);
        this.buildTower(10.0, d - 360.0, 15.0, TAN);
    }

    private void buildTower(double d, double d2, double d3, Color color) {
        double d4 = this.calculateXCoordinate(d);
        GRect gRect = new GRect(d4, d2, d, d3);
        gRect.setFilled(true);
        gRect.setFillColor(color);
        this.add((GObject)gRect);
    }

    private void buildDome(double d, double d2, Color color) {
        double d3 = this.calculateXCoordinate(d);
        GOval gOval = new GOval(d3, d2, d, d);
        gOval.setFilled(true);
        gOval.setFillColor(color);
        this.add((GObject)gOval);
    }

    private void buildWindows() {
        double d = this.getWidth() / 2;
        double d2 = this.getHeight();
        this.makeWindowTop(d - 24.0, d2 - 302.42857142857144, 12.0);
        this.makeWindowBottom(d - 24.0, d2 - 296.42857142857144, 12.0, 39.0);
        this.makeWindowTop(d + 12.0, d2 - 302.42857142857144, 12.0);
        this.makeWindowBottom(d + 12.0, d2 - 296.42857142857144, 12.0, 39.0);
    }

    private void makeWindowBottom(double d, double d2, double d3, double d4) {
        GRect gRect = new GRect(d, d2, d3, d4);
        gRect.setFilled(true);
        gRect.setFillColor(Color.BLACK);
        this.add((GObject)gRect);
    }

    private void makeWindowTop(double d, double d2, double d3) {
        GOval gOval = new GOval(d, d2, d3, d3);
        gOval.setFilled(true);
        gOval.setFillColor(Color.BLACK);
        this.add((GObject)gOval);
    }

    private void buildAccents() {
        double d = this.getWidth() / 2;
        double d2 = this.getHeight();
        double d3 = d - 13.335999999999999;
        double d4 = d + 13.335999999999999;
        this.addAccent(d3, d2, d2 - 250.0);
        this.addAccent(d4, d2, d2 - 250.0);
    }

    private void addAccent(double d, double d2, double d3) {
        this.add((GObject)new GLine(d, d2, d, d3));
    }

    private void addSignature() {
        GLabel gLabel = new GLabel("Artistry by Ben Kirshner");
        gLabel.setFont("Lucida Calligraphy-20");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getDescent();
        this.add((GObject)gLabel, d, d2);
    }

    private double calculateXCoordinate(double d) {
        double d2 = this.getWidth() / 2;
        double d3 = d2 - d / 2.0;
        return d3;
    }
}

