/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPolygon;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;
import java.awt.Font;

public class Artistry
extends GraphicsProgram {
    private static int RED_VALUE = 222;
    private static int GREEN_VALUE = 184;
    private static int BLUE_VALUE = 135;
    private static Color BACKGROUND_COLOR = new Color(RED_VALUE, GREEN_VALUE, BLUE_VALUE);
    private static int WING_HEIGHT = 200;
    private static int WING_WIDTH = 100;
    private static int dx0 = 15;
    private static int dy0 = 25;
    private static int dx1a = -200;
    private static int dy1a = -35;
    private static int dx2a = 15;
    private static int dy2a = 50;
    private static int dx3a = 185;
    private static int dy3a = 10;
    private static int dx4a = 0;
    private static int dy4a = -25;
    private static int dx1b = -175;
    private static int dy1b = 10;
    private static int dx2b = 10;
    private static int dy2b = 50;
    private static int dx3b = 165;
    private static int dy3b = -25;
    private static int dx4b = 0;
    private static int dy4b = -35;
    private static int dx1c = -150;
    private static int dy1c = 50;
    private static int dx2c = 30;
    private static int dy2c = 30;
    private static int dx3c = 120;
    private static int dy3c = -50;
    private static int dx4c = 0;
    private static int dy4c = -30;
    private static int dx1d = -30;
    private static int dy1d = 80;
    private static int dx2d = 45;
    private static int dy2d = 10;
    private static int dx3d = 20;
    private static int dy3d = -70;
    private static int dx4d = -35;
    private static int dy4d = -20;
    private static int TRIFORCE_SIDE_LENGTH = 100;
    private static double TRIFORCE_HEIGHT = 100.0 * Math.sqrt(3.0);

    public void run() {
        this.drawBackground();
        this.drawWings();
        this.drawBody();
        this.drawTriangles();
        this.drawSignature();
    }

    private void drawBackground() {
        GRect gRect = new GRect((double)this.getWidth(), (double)this.getHeight());
        gRect.setFilled(true);
        gRect.setColor(BACKGROUND_COLOR);
        this.add((GObject)gRect);
    }

    private void drawWings() {
        double d = (this.getWidth() - WING_WIDTH) / 2 - WING_WIDTH;
        double d2 = ((double)this.getHeight() - 1.5 * (double)WING_HEIGHT) / 2.0;
        double d3 = (this.getWidth() - WING_WIDTH) / 2 + WING_WIDTH;
        double d4 = ((double)this.getHeight() - 1.5 * (double)WING_HEIGHT) / 2.0;
        GOval gOval = new GOval(d, d2, (double)WING_WIDTH, (double)WING_HEIGHT);
        gOval.setFilled(true);
        gOval.setColor(Color.YELLOW);
        this.add((GObject)gOval);
        GOval gOval2 = new GOval(d3, d4, (double)WING_WIDTH, (double)WING_HEIGHT);
        gOval2.setFilled(true);
        gOval2.setColor(Color.YELLOW);
        this.add((GObject)gOval2);
        this.drawWingSpace(d, d2, d3, d4);
        this.drawFeathers(d, d2, d3, d4);
    }

    private void drawWingSpace(double d, double d2, double d3, double d4) {
        double d5 = d + (double)(WING_WIDTH / 4);
        double d6 = d2;
        double d7 = d3 - (double)(WING_WIDTH / 4);
        double d8 = d4;
        GOval gOval = new GOval(d5, d6, (double)WING_WIDTH, (double)(5 * WING_HEIGHT / 6));
        gOval.setFilled(true);
        gOval.setColor(BACKGROUND_COLOR);
        this.add((GObject)gOval);
        GOval gOval2 = new GOval(d7, d8, (double)WING_WIDTH, (double)(5 * WING_HEIGHT / 6));
        gOval2.setFilled(true);
        gOval2.setColor(BACKGROUND_COLOR);
        this.add((GObject)gOval2);
    }

    private void drawFeathers(double d, double d2, double d3, double d4) {
        this.drawLeftFeathers(d, d2);
        this.drawRightFeathers(d3, d4);
    }

    private void drawLeftFeathers(double d, double d2) {
        double d3 = d + (double)dx0;
        double d4 = d2 + (double)dy0;
        GPolygon gPolygon = new GPolygon(d3, d4);
        gPolygon.addEdge((double)dx1a, (double)dy1a);
        gPolygon.addEdge((double)dx2a, (double)dy2a);
        gPolygon.addEdge((double)dx3a, (double)dy3a);
        gPolygon.addEdge((double)dx4a, (double)dy4a);
        gPolygon.setFilled(true);
        gPolygon.setColor(Color.YELLOW);
        this.add((GObject)gPolygon);
        double d5 = d3 + (double)(dx0 / 2);
        double d6 = d4 + (double)(2 * dy0);
        GPolygon gPolygon2 = new GPolygon(d5, d6);
        gPolygon2.addEdge((double)dx1b, (double)dy1b);
        gPolygon2.addEdge((double)dx2b, (double)dy2b);
        gPolygon2.addEdge((double)dx3b, (double)dy3b);
        gPolygon2.addEdge((double)dx4b, (double)dy4b);
        gPolygon2.setFilled(true);
        gPolygon2.setColor(Color.YELLOW);
        this.add((GObject)gPolygon2);
        double d7 = d5 + (double)(dx0 / 2);
        double d8 = d6 + (double)(2 * dy0);
        GPolygon gPolygon3 = new GPolygon(d7, d8);
        gPolygon3.addEdge((double)dx1c, (double)dy1c);
        gPolygon3.addEdge((double)dx2c, (double)dy2c);
        gPolygon3.addEdge((double)dx3c, (double)dy3c);
        gPolygon3.addEdge((double)dx4c, (double)dy4c);
        gPolygon3.setFilled(true);
        gPolygon3.setColor(Color.YELLOW);
        this.add((GObject)gPolygon3);
        double d9 = d7;
        double d10 = d8 + 1.5 * (double)dy0;
        GPolygon gPolygon4 = new GPolygon(d9, d10);
        gPolygon4.addEdge((double)dx1d, (double)dy1d);
        gPolygon4.addEdge((double)dx2d, (double)dy2d);
        gPolygon4.addEdge((double)dx3d, (double)dy3d);
        gPolygon4.addEdge((double)dx4d, (double)dy4d);
        gPolygon4.setFilled(true);
        gPolygon4.setColor(Color.YELLOW);
        this.add((GObject)gPolygon4);
    }

    private void drawRightFeathers(double d, double d2) {
        double d3 = d + (double)WING_WIDTH - (double)dx0;
        double d4 = d2 + (double)dy0;
        GPolygon gPolygon = new GPolygon(d3, d4);
        gPolygon.addEdge((double)(-dx1a), (double)dy1a);
        gPolygon.addEdge((double)(-dx2a), (double)dy2a);
        gPolygon.addEdge((double)(-dx3a), (double)dy3a);
        gPolygon.addEdge((double)(-dx4a), (double)dy4a);
        gPolygon.setFilled(true);
        gPolygon.setColor(Color.YELLOW);
        this.add((GObject)gPolygon);
        double d5 = d3 - (double)(dx0 / 2);
        double d6 = d4 + (double)(2 * dy0);
        GPolygon gPolygon2 = new GPolygon(d5, d6);
        gPolygon2.addEdge((double)(-dx1b), (double)dy1b);
        gPolygon2.addEdge((double)(-dx2b), (double)dy2b);
        gPolygon2.addEdge((double)(-dx3b), (double)dy3b);
        gPolygon2.addEdge((double)(-dx4b), (double)dy4b);
        gPolygon2.setFilled(true);
        gPolygon2.setColor(Color.YELLOW);
        this.add((GObject)gPolygon2);
        double d7 = d5 - (double)(dx0 / 2);
        double d8 = d6 + (double)(2 * dy0);
        GPolygon gPolygon3 = new GPolygon(d7, d8);
        gPolygon3.addEdge((double)(-dx1c), (double)dy1c);
        gPolygon3.addEdge((double)(-dx2c), (double)dy2c);
        gPolygon3.addEdge((double)(-dx3c), (double)dy3c);
        gPolygon3.addEdge((double)(-dx4c), (double)dy4c);
        gPolygon3.setFilled(true);
        gPolygon3.setColor(Color.YELLOW);
        this.add((GObject)gPolygon3);
        double d9 = d7;
        double d10 = d8 + 1.5 * (double)dy0;
        GPolygon gPolygon4 = new GPolygon(d9, d10);
        gPolygon4.addEdge((double)(-dx1d), (double)dy1d);
        gPolygon4.addEdge((double)(-dx2d), (double)dy2d);
        gPolygon4.addEdge((double)(-dx3d), (double)dy3d);
        gPolygon4.addEdge((double)(-dx4d), (double)dy4d);
        gPolygon4.setFilled(true);
        gPolygon4.setColor(Color.YELLOW);
        this.add((GObject)gPolygon4);
    }

    private void drawBody() {
        double d = (this.getWidth() - WING_WIDTH) / 2;
        double d2 = this.getHeight() / 2 + WING_HEIGHT / 10;
        GRect gRect = new GRect(d, d2, (double)WING_WIDTH, (double)(WING_HEIGHT / 2));
        gRect.setFilled(true);
        gRect.setColor(Color.YELLOW);
        this.add((GObject)gRect);
        double d3 = (this.getWidth() - WING_WIDTH / 2) / 2;
        double d4 = d2 + gRect.getHeight();
        GRect gRect2 = new GRect(d3, d4, (double)(WING_WIDTH / 2), (double)(WING_HEIGHT / 2));
        gRect2.setFilled(true);
        gRect2.setColor(Color.YELLOW);
        this.add((GObject)gRect2);
    }

    private void drawTriangles() {
        double d = this.getWidth() / 2;
        double d2 = (double)(this.getHeight() / 2) - TRIFORCE_HEIGHT - (double)(TRIFORCE_SIDE_LENGTH / 2);
        GPolygon gPolygon = new GPolygon(d, d2);
        gPolygon.addEdge((double)(-TRIFORCE_SIDE_LENGTH), TRIFORCE_HEIGHT);
        gPolygon.addEdge((double)(2 * TRIFORCE_SIDE_LENGTH), 0.0);
        gPolygon.addEdge((double)(-TRIFORCE_SIDE_LENGTH), -TRIFORCE_HEIGHT);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(Color.ORANGE);
        this.add((GObject)gPolygon);
        GPolygon gPolygon2 = new GPolygon(d, d2 + TRIFORCE_HEIGHT);
        gPolygon2.addEdge((double)(TRIFORCE_SIDE_LENGTH / 2), -TRIFORCE_HEIGHT / 2.0);
        gPolygon2.addEdge((double)(-TRIFORCE_SIDE_LENGTH), 0.0);
        gPolygon2.addEdge((double)(TRIFORCE_SIDE_LENGTH / 2), TRIFORCE_HEIGHT / 2.0);
        gPolygon2.setFilled(true);
        gPolygon2.setFillColor(BACKGROUND_COLOR);
        this.add((GObject)gPolygon2);
    }

    private void drawSignature() {
        GLabel gLabel = new GLabel("Inspired by The Legend of Zelda");
        gLabel.setFont(new Font("Comic Sans", 1, 20));
        gLabel.setLocation(0.0, gLabel.getAscent());
        this.add((GObject)gLabel);
        GLabel gLabel2 = new GLabel("Artistry by Camilo Esteban Arevalo");
        gLabel2.setFont(new Font("Comic Sans", 2, 18));
        gLabel2.setLocation((double)this.getWidth() - gLabel2.getWidth(), (double)this.getHeight() - gLabel2.getDescent());
        this.add((GObject)gLabel2);
    }
}

