/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPolygon;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import acm.util.RandomGenerator;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    public static final Color MIDNIGHT_BLUE = new Color(25, 25, 112);
    public static final Color CADET_BLUE = new Color(95, 158, 160);
    public static final Color LIGHT_YELLOW = new Color(255, 255, 224);
    public static final Color DARK_OLIVE_GREEN = new Color(85, 107, 47);
    private static final double MOON_DIAMETER = 72.0;
    private static final double MOON_DISTANCE_FROM_EDGE = 25.0;
    private static final double LIGHT_STREAK_WIDTH = 30.0;
    private static final double NUMBER_OF_STARS = 10.0;
    private static final double STAR_SIZE_UPPERBOUND = 25.0;
    private static final double STAR_SIZE_LOWERBOUND = 10.0;
    private static final double TREE_DISTANCE_FROM_EDGE = 30.0;
    private static final double TREE_THICKNESS = 200.0;
    private RandomGenerator rgen = RandomGenerator.getInstance();

    public void run() {
        this.drawSky();
        this.drawGround();
        this.drawCity();
        this.drawLightStreak();
        this.drawMoon(72.0);
        this.drawStar();
        this.drawTree();
        this.signName();
    }

    private void drawSky() {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(0.0, 0.0);
        gPolygon.addVertex((double)this.getWidth(), 0.0);
        gPolygon.addVertex((double)this.getWidth(), (double)(this.getHeight() / 2));
        gPolygon.addVertex(0.0, (double)(3 * this.getHeight() / 4));
        gPolygon.setFilled(true);
        gPolygon.setColor(MIDNIGHT_BLUE);
        this.add((GObject)gPolygon, 0.0, 0.0);
    }

    private void drawGround() {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(0.0, (double)(3 * this.getHeight() / 4));
        gPolygon.addVertex((double)this.getWidth(), (double)(this.getHeight() / 2));
        gPolygon.addVertex((double)this.getWidth(), (double)this.getHeight());
        gPolygon.addVertex(0.0, (double)this.getHeight());
        gPolygon.setFilled(true);
        gPolygon.setColor(CADET_BLUE);
        this.add((GObject)gPolygon, 0.0, 0.0);
    }

    private void drawCity() {
        GRect gRect = new GRect(0.0, (double)(4 * this.getHeight() / 5), (double)this.getWidth(), (double)(this.getHeight() / 5));
        gRect.setFilled(true);
        gRect.setColor(Color.DARK_GRAY);
        this.add((GObject)gRect);
    }

    private void drawLightStreak() {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(0.0, (double)(3 * this.getHeight() / 4));
        gPolygon.addVertex(0.0, (double)(3 * this.getHeight() / 4) - 30.0);
        gPolygon.addVertex((double)this.getWidth(), (double)(this.getHeight() / 2) - 45.0);
        gPolygon.addVertex((double)this.getWidth(), (double)(this.getHeight() / 2));
        gPolygon.setFilled(true);
        gPolygon.setColor(LIGHT_YELLOW);
        this.add((GObject)gPolygon, 0.0, 0.0);
    }

    private void drawMoon(double d) {
        GOval gOval = new GOval((double)this.getWidth() - d - 25.0, 25.0, d, d);
        gOval.setFilled(true);
        gOval.setColor(Color.YELLOW);
        this.add((GObject)gOval);
    }

    private void drawStar() {
        int n = 0;
        while ((double)n < 10.0) {
            double d = this.rgen.nextDouble(0.0, (double)this.getWidth() - 25.0 - 72.0);
            double d2 = this.rgen.nextDouble(0.0, (double)(this.getHeight() / 2) - 45.0);
            double d3 = this.rgen.nextDouble(25.0, 10.0);
            GOval gOval = new GOval(d, d2, d3, d3);
            gOval.setFilled(true);
            gOval.setColor(Color.YELLOW);
            this.add((GObject)gOval);
            ++n;
        }
    }

    private void drawTree() {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(0.0, 0.0);
        gPolygon.addVertex(0.0, (double)(-7 * this.getHeight() / 8));
        gPolygon.addVertex(100.0, (double)(-this.getHeight() / 4));
        gPolygon.addVertex(100.0, (double)(-3 * this.getHeight() / 5));
        gPolygon.addVertex(200.0, 0.0);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(DARK_OLIVE_GREEN);
        this.add((GObject)gPolygon, 30.0, this.getHeight());
    }

    private void signName() {
        GLabel gLabel = new GLabel("Artistry by Guanlin Chen");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getDescent();
        gLabel.setColor(Color.WHITE);
        this.add((GObject)gLabel, d, d2);
    }
}

