/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GArc;
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final int SIGNATURE_CLEARANCE = 20;
    private static final int CUBE_WIDTH = 350;
    private static final Color HEART_PINK = new Color(255, 200, 200);

    public void run() {
        double d = this.getWidth() / 2;
        double d2 = this.getHeight() / 2;
        this.buildCube(d, d2);
        this.artistryLabel();
    }

    private void artistryLabel() {
        GLabel gLabel = new GLabel("Artistry by Juliana Cook");
        gLabel.setFont("Zapfino");
        double d = (double)this.getWidth() - gLabel.getWidth() - 20.0;
        double d2 = (double)this.getHeight() - gLabel.getDescent();
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }

    private void buildCube(double d, double d2) {
        this.buildBackground(d, d2, Color.LIGHT_GRAY);
        this.buildForeground(d, d2, Color.GRAY);
        this.buildFace(d, d2, HEART_PINK, Color.LIGHT_GRAY);
    }

    private void buildBackground(double d, double d2, Color color) {
        double d3 = d - 175.0;
        double d4 = d2 - 175.0;
        GRect gRect = new GRect(d3, d4, 350.0, 350.0);
        gRect.setColor(color);
        gRect.setFilled(true);
        this.add((GObject)gRect);
    }

    private void buildForeground(double d, double d2, Color color) {
        this.buildForegroundCircle(d, d2, color);
        this.buildHorizontalLine(d2 - 70.0, d, d2, color);
        this.buildHorizontalLine(d2 + 35.0, d, d2, color);
        this.buildVerticalLine(d - 70.0, d, d2, color);
        this.buildVerticalLine(d + 35.0, d, d2, color);
    }

    private void buildForegroundCircle(double d, double d2, Color color) {
        double d3 = d - 131.0;
        double d4 = d2 - 131.0;
        double d5 = 262.0;
        GOval gOval = new GOval(d3, d4, d5, d5);
        gOval.setColor(color);
        gOval.setFilled(true);
        this.add((GObject)gOval);
    }

    private void buildHorizontalLine(double d, double d2, double d3, Color color) {
        double d4 = d2 - 175.0;
        GRect gRect = new GRect(d4, d, 350.0, 35.0);
        gRect.setColor(color);
        gRect.setFilled(true);
        this.add((GObject)gRect);
    }

    private void buildVerticalLine(double d, double d2, double d3, Color color) {
        double d4 = d3 - 175.0;
        GRect gRect = new GRect(d, d4, 35.0, 350.0);
        gRect.setColor(color);
        gRect.setFilled(true);
        this.add((GObject)gRect);
    }

    private void buildFace(double d, double d2, Color color, Color color2) {
        this.buildFaceLine(d - 131.0, d2, d + 131.0, d2, color);
        this.buildFaceLine(d, d2 - 131.0, d, d2 + 131.0, color);
        this.buildFaceCircle(d, d2, color2);
        this.buildHeart(d, d2, color);
    }

    private void buildFaceLine(double d, double d2, double d3, double d4, Color color) {
        GLine gLine = new GLine(d, d2, d3, d4);
        gLine.setColor(color);
        this.add((GObject)gLine);
    }

    private void buildFaceCircle(double d, double d2, Color color) {
        double d3 = d - 105.0;
        double d4 = d2 - 105.0;
        double d5 = 210.0;
        GOval gOval = new GOval(d3, d4, d5, d5);
        gOval.setColor(color);
        gOval.setFilled(true);
        this.add((GObject)gOval);
    }

    private void buildHeart(double d, double d2, Color color) {
        double d3 = 70.0;
        this.topHeart(d - d3 * 0.05, d, d2, d3, color);
        this.topHeart(d - d3 * 0.95, d, d2, d3, color);
        this.bottomHeart(d, d2, color);
    }

    private void topHeart(double d, double d2, double d3, double d4, Color color) {
        GOval gOval = new GOval(d, d3 - d4 * 0.85, d4, d4);
        gOval.setFilled(true);
        gOval.setColor(color);
        this.add((GObject)gOval);
    }

    private void bottomHeart(double d, double d2, Color color) {
        double d3 = 175.0;
        GArc gArc = new GArc(d3, d3, 50.0, 80.0);
        gArc.setFilled(true);
        gArc.setColor(color);
        this.add((GObject)gArc, d - 0.5 * d3, d2 - 0.1 * d3);
    }
}

