/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final int BODY_WIDTH = 400;
    private static final int BODY_HEIGHT = 105;
    private static final int NECK_HEIGHT = 300;
    private static final int NECK_WIDTH = 100;
    private static final int RADIUS_OF_FACIAL_FEATURES = 10;
    private static final int RADIUS_OF_MOUTH = 25;
    private static final int SHELL_CENTER_X = 500;
    private static final int SHELL_CENTER_Y = 250;

    public void run() {
        this.addRectangles();
        this.addFeatures();
        this.addText();
    }

    private void drawRect(double d, double d2, double d3, double d4, Color color) {
        GRect gRect = new GRect(d, d2, d3, d4);
        gRect.setFilled(true);
        gRect.setFillColor(color);
        this.add((GObject)gRect);
    }

    private void drawRectWithNoOutline(double d, double d2, double d3, double d4, Color color) {
        GRect gRect = new GRect(d, d2, d3, d4);
        gRect.setColor(color);
        gRect.setFilled(true);
        this.add((GObject)gRect);
    }

    private void drawCircle(double d, double d2, double d3, Color color) {
        double d4 = d - d3;
        double d5 = d2 - d3;
        GOval gOval = new GOval(2.0 * d3, 2.0 * d3);
        gOval.setFilled(true);
        gOval.setFillColor(color);
        this.add((GObject)gOval, d4, d5);
    }

    private void addRectangles() {
        this.drawRect(0.0, 0.0, this.getWidth(), this.getHeight(), Color.MAGENTA);
        this.drawRect(this.getWidth() / 7, this.getHeight() * 3 / 5, 400.0, 105.0, Color.YELLOW);
        this.drawRect(this.getWidth() / 7, this.getHeight() / 5, 100.0, 300.0, Color.YELLOW);
        this.drawRectWithNoOutline(this.getWidth() / 7 + 1, this.getHeight() * 3 / 5 + 1, 398.0, 103.0, Color.YELLOW);
    }

    private void addFeatures() {
        this.add((GObject)new GLine((double)(this.getWidth() / 7 + 25), (double)(this.getHeight() / 10), (double)(this.getWidth() / 7 + 25), (double)(this.getHeight() / 5)));
        this.add((GObject)new GLine((double)(this.getWidth() / 7 + 75), (double)(this.getHeight() / 10), (double)(this.getWidth() / 7 + 75), (double)(this.getHeight() / 5)));
        this.drawCircle(this.getWidth() / 7 + 25, this.getHeight() / 10, 10.0, Color.YELLOW);
        this.drawCircle(this.getWidth() / 7 + 75, this.getHeight() / 10, 10.0, Color.YELLOW);
        this.drawCircle(this.getWidth() / 7 + 25, this.getHeight() / 4, 10.0, Color.BLUE);
        this.drawCircle(this.getWidth() / 7 + 75, this.getHeight() / 4, 10.0, Color.BLUE);
        this.drawCircle(this.getWidth() / 7 + 50, this.getHeight() / 3, 25.0, Color.RED);
        this.drawRectWithNoOutline(this.getWidth() / 7 + 1, this.getHeight() / 3 - 25, 98.0, 25.0, Color.YELLOW);
        this.drawCircle(500.0, 250.0, 200.0, Color.ORANGE);
        this.drawCircle(500.0, 250.0, 150.0, Color.ORANGE);
        this.drawCircle(500.0, 250.0, 100.0, Color.ORANGE);
        this.drawCircle(500.0, 250.0, 50.0, Color.ORANGE);
    }

    private void addText() {
        GLabel gLabel = new GLabel("Why did the snail cross the road?");
        double d = (double)this.getWidth() - 2.0 * gLabel.getWidth();
        double d2 = 2.0 * gLabel.getAscent();
        gLabel.setFont("Big Caslon-24");
        this.add((GObject)gLabel, d, d2);
        GLabel gLabel2 = new GLabel("I don't know, but I'll let you know when it gets here.");
        double d3 = gLabel2.getWidth() / 8.0;
        double d4 = (double)this.getHeight() - gLabel2.getAscent();
        gLabel2.setFont("Big Caslon-24");
        this.add((GObject)gLabel2, d3, d4);
        GLabel gLabel3 = new GLabel("Dafna Szafer");
        double d5 = (double)this.getWidth() - 1.5 * gLabel3.getWidth();
        double d6 = (double)this.getHeight() - gLabel3.getHeight() / 2.0;
        gLabel3.setFont("Big Caslon-16");
        this.add((GObject)gLabel3, d5, d6);
    }
}

