/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPolygon;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double TRIANGLE_WIDTH = 300.0;
    private static final double TRIANGLE_HEIGHT = 300.0;
    private static final double CIRCLE_DIAMETER = 100.0;
    private static final double CIRCLE_ONE_CENTER_X = 325.0;
    private static final double CIRCLE_ONE_CENTER_Y = 50.0;
    private static final double CIRCLE_TWO_CENTER_X = 170.0;
    private static final double CIRCLE_TWO_CENTER_Y = 340.0;
    private static final double CIRCLE_THREE_CENTER_X = 475.0;
    private static final double CIRCLE_THREE_CENTER_Y = 340.0;

    public void run() {
        this.createMySignature();
        this.createUpsideDownTriangle();
        this.createSolidCircle(325.0, 50.0);
        this.createSolidCircle(170.0, 340.0);
        this.createSolidCircle(475.0, 340.0);
        this.createInvisibleTriangle();
        this.createTitle();
    }

    private void createMySignature() {
        GLabel gLabel = new GLabel("Artistry by Eric Gomez");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getAscent() / 2.0;
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }

    private void createUpsideDownTriangle() {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(0.0, 150.0);
        gPolygon.addVertex(-150.0, -150.0);
        gPolygon.addVertex(150.0, -150.0);
        this.add((GObject)gPolygon, this.getWidth() / 2, this.getHeight() / 2 + 75);
    }

    private void createInvisibleTriangle() {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(0.0, -150.0);
        gPolygon.addVertex(150.0, 150.0);
        gPolygon.addVertex(-150.0, 150.0);
        gPolygon.setFilled(true);
        gPolygon.setColor(Color.WHITE);
        this.add((GObject)gPolygon, this.getWidth() / 2, this.getHeight() / 2);
    }

    private void createSolidCircle(double d, double d2) {
        GOval gOval = new GOval(d, d2, 100.0, 100.0);
        gOval.setFilled(true);
        gOval.setColor(Color.BLACK);
        this.add((GObject)gOval);
    }

    private void createTitle() {
        GLabel gLabel = new GLabel("The 'Ironic' Kanizsa Triangle Illusion");
        double d = 0.0;
        double d2 = (double)this.getHeight() - gLabel.getAscent() / 2.0;
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }
}

