/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final int STAFF_HEIGHT = 100;
    private static final int STAFF_LINE_SPACE = 70;
    private static final int STAFF_BEGINNING = 50;
    private static final int STAFF_ENDING = 700;
    private static final int BARLINE_TOP = 100;
    private static final int BARLINE_BOTTOM = 380;
    private static final int BARLINE_X = 480;
    private static final int TIME_SIGNATURE_TWO_Y = 220;
    private static final int TIME_SIGNATURE_FOUR_Y = 360;
    private static final int TIME_SIGNATURE_X = 70;
    private static final int EIGHTH_NOTE_BODY_X = 150;
    private static final int EIGHTH_NOTE_BODY_Y = 290;
    private static final int EIGHTH_NOTE_SPACE = 60;
    private static final int EIGHTH_NOTE_SPACE_MINUS_A_LITTLE = 56;
    private static final int EIGHTH_NOTE_LINE_TOP = 180;
    private static final int EIGHTH_NOTE_LINE_BOTTOM = 310;
    private static final int BEAM_LENGTH = 240;
    private static final int BEAM_THICKNESS = 20;
    private static final int FLAT_SIGN_X = 500;
    private static final int FLAT_SIGN_Y = 380;
    private static final int HALF_NOTE_X = 550;
    private static final int HALF_NOTE_Y = 350;
    private static final int HALF_NOTE_LINE_X = 610;
    private static final int HALF_NOTE_LINE_TOP = 200;
    private static final int HALF_NOTE_LINE_BOTTOM = 380;
    private static final int WIDTH_OF_BEETHOVENS_NAME = 480;
    private static final int HEIGHT_OF_BEETHOVENS_NAME = 50;
    int staffCounter = 0;
    int eighthNoteCounter = 0;

    public void run() {
        this.createFiveStaffLines();
        this.createBarLine();
        this.createTimeSignature();
        this.createThreeEighthNoteGs();
        this.createHalfNoteEFlat();
        this.createBeethovensName();
        this.createMyName();
    }

    private void createFiveStaffLines() {
        this.staffCounter = 0;
        while (this.staffCounter < 5) {
            this.createNextStaff();
            ++this.staffCounter;
        }
    }

    private void createNextStaff() {
        GLine gLine = new GLine(50.0, (double)(100 + 70 * this.staffCounter), 700.0, (double)(100 + 70 * this.staffCounter));
        this.add((GObject)gLine);
    }

    private void createBarLine() {
        GLine gLine = new GLine(480.0, 100.0, 480.0, 380.0);
        this.add((GObject)gLine);
    }

    private void createTimeSignature() {
        this.createTwo();
        this.createFour();
    }

    private void createTwo() {
        GLabel gLabel = new GLabel("2", 70.0, 220.0);
        gLabel.setFont("HELVETICA-140");
        this.add((GObject)gLabel);
    }

    private void createFour() {
        GLabel gLabel = new GLabel("4", 70.0, 360.0);
        gLabel.setFont("HELVETICA-140");
        this.add((GObject)gLabel);
    }

    private void createThreeEighthNoteGs() {
        this.eighthNoteCounter = 0;
        while (this.eighthNoteCounter < 3) {
            this.createNextEighthNote();
            ++this.eighthNoteCounter;
        }
        this.createBeam();
    }

    private void createNextEighthNote() {
        GOval gOval = new GOval((double)(150 + this.eighthNoteCounter * 60 * 2), 290.0, 60.0, 56.0);
        gOval.setFilled(true);
        gOval.setFillColor(Color.BLACK);
        this.add((GObject)gOval);
        GLine gLine = new GLine((double)(210 + this.eighthNoteCounter * 60 * 2), 180.0, (double)(210 + this.eighthNoteCounter * 60 * 2), 310.0);
        this.add((GObject)gLine);
    }

    private void createBeam() {
        GRect gRect = new GRect(210.0, 180.0, 240.0, 20.0);
        gRect.setFilled(true);
        gRect.setFillColor(Color.BLACK);
        this.add((GObject)gRect);
    }

    private void createHalfNoteEFlat() {
        this.createFlatSign();
        this.createHalfNoteBody();
        this.createHalfNoteLine();
    }

    private void createFlatSign() {
        GLabel gLabel = new GLabel("b", 500.0, 380.0);
        gLabel.setFont("Maestro-100");
        this.add((GObject)gLabel);
    }

    private void createHalfNoteBody() {
        GOval gOval = new GOval(550.0, 350.0, 60.0, 56.0);
        gOval.setFilled(false);
        gOval.setColor(Color.BLACK);
        this.add((GObject)gOval);
    }

    private void createHalfNoteLine() {
        GLine gLine = new GLine(610.0, 200.0, 610.0, 380.0);
        this.add((GObject)gLine);
    }

    private void createBeethovensName() {
        GLabel gLabel = new GLabel("Ludwig von Beethoven", (double)(this.getWidth() - 480), 50.0);
        gLabel.setFont("Lucida Blackletter-48");
        gLabel.setColor(Color.RED);
        this.add((GObject)gLabel);
    }

    private void createMyName() {
        GLabel gLabel = new GLabel("Artistry by ET");
        gLabel.setFont("Helvetica-30");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getAscent() / 2.0;
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }
}

