/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double BODY_WIDTH = 100.0;
    private static final double BODY_HEIGHT = 200.0;
    private static final double EYE_DIAMETER = 50.0;
    private static final double PUPIL_DIAMETER = 30.0;
    private static final double HAIR_LENGTH = 10.0;

    public void run() {
        this.drawBody();
        this.drawEye();
        this.drawHair();
        this.signName();
    }

    private void drawBody() {
        double d = (double)(this.getWidth() / 2) - 50.0;
        double d2 = this.getHeight() / 2;
        this.drawHead(d, d2);
        this.drawBottom(d, d2);
        this.drawTorso(d, d2);
    }

    private void drawHead(double d, double d2) {
        this.drawCircle(d, d2 - 100.0, 100.0, Color.YELLOW);
    }

    private void drawBottom(double d, double d2) {
        this.drawCircle(d, d2, 100.0, Color.YELLOW);
    }

    private void drawCircle(double d, double d2, double d3, Color color) {
        GOval gOval = new GOval(d, d2, d3, d3);
        gOval.setFilled(true);
        gOval.setColor(color);
        this.add((GObject)gOval);
    }

    private void drawTorso(double d, double d2) {
        GRect gRect = new GRect(d, d2 - 50.0, 100.0, 100.0);
        gRect.setFilled(true);
        gRect.setColor(Color.YELLOW);
        this.add((GObject)gRect);
    }

    private void drawEye() {
        double d = this.getWidth() / 2;
        double d2 = (double)(this.getHeight() / 2) - 50.0;
        this.drawCircle(d - 25.0, d2, 50.0, Color.WHITE);
        this.drawCircle(d - 15.0, d2 + 15.0, 30.0, Color.BLACK);
    }

    private void drawHair() {
        double d = this.getWidth() / 2;
        double d2 = (double)(this.getHeight() / 2) - 100.0;
        GLine gLine = new GLine(d, d2 - 10.0, d, d2);
        this.add((GObject)gLine);
    }

    private void signName() {
        GLabel gLabel = new GLabel("Artistry by Grace");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getAscent();
        this.add((GObject)gLabel, d, d2);
    }
}

