/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GArc;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.program.GraphicsProgram;
import acm.util.RandomGenerator;

public class Artistry
extends GraphicsProgram {
    private static final int NUMBER_OF_ARCS = 20;
    private static final double GOLDEN_RATIO = (1.0 + Math.sqrt(5.0)) / 2.0;
    private static final int SWEEP_ANGLE = 90;
    private static final double STARTX = 0.0;
    private static final double STARTY = 0.0;
    private RandomGenerator rgen = RandomGenerator.getInstance();

    public void run() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 1; i <= 20; ++i) {
            this.add((GObject)this.arc(i, d, d2));
            GPoint gPoint = this.arc(i, d, d2).getEndPoint();
            d = gPoint.getX();
            d2 = gPoint.getY();
        }
    }

    private GArc arc(int n, double d, double d2) {
        double d3 = (double)(this.getWidth() / 2) / Math.pow(GOLDEN_RATIO, n - 1);
        int n2 = 90 * (n - 1);
        int n3 = 90;
        GArc gArc = new GArc(this.getXPos(d3, n, d), this.getYPos(d3, n, d2), 2.0 * d3, 2.0 * d3, (double)n2, (double)n3);
        gArc.setFilled(true);
        gArc.setFillColor(this.rgen.nextColor());
        return gArc;
    }

    private double getXPos(double d, int n, double d2) {
        double d3;
        if (n == 1) {
            return 0.0;
        }
        int n2 = n % 4;
        switch (n2) {
            case 1: {
                d3 = -2.0 * d;
                break;
            }
            case 2: {
                d3 = -1.0 * d;
                break;
            }
            case 3: {
                d3 = 0.0;
                break;
            }
            case 0: {
                d3 = -d;
                break;
            }
            default: {
                d3 = 0.0;
            }
        }
        return d2 + d3;
    }

    private double getYPos(double d, int n, double d2) {
        double d3;
        if (n == 1) {
            return 0.0;
        }
        int n2 = n % 4;
        switch (n2) {
            case 1: {
                d3 = -d;
                break;
            }
            case 2: {
                d3 = 0.0;
                break;
            }
            case 3: {
                d3 = -d;
                break;
            }
            case 0: {
                d3 = -2.0 * d;
                break;
            }
            default: {
                d3 = 0.0;
            }
        }
        return d2 + d3;
    }
}

