/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import acm.util.RandomGenerator;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final int BRICK_WIDTH = 30;
    private static final int BRICK_HEIGHT = 12;
    private static final int BRICKS_IN_BASE = 14;
    private static final double RADIUS_BIG_CIRCLE = 72.0;
    private static final double RADIUS_MEDIUM_CIRCLE = 46.800000000000004;
    private static final double RADIUS_SMALL_CIRCLE = 21.599999999999998;
    private RandomGenerator rgen = new RandomGenerator();

    public void run() {
        this.wingTieLeft();
        this.wingTieRight();
        this.tieCenter();
        this.artistryBy();
        this.meetTieFighter();
        this.setBackground(Color.yellow);
    }

    private void wingTieLeft() {
        for (int i = 0; i < 14; ++i) {
            for (int j = 0; j < 14 - i; ++j) {
                double d = this.getHeight() / 2 + i * 30 / 2 - 210 + j * 30;
                double d2 = 144.0 + (double)(i * 12);
                GRect gRect = new GRect(d2, d, 30.0, 12.0);
                gRect.setColor(this.rgen.nextColor());
                gRect.setFilled(true);
                this.add((GObject)gRect);
            }
        }
    }

    private void wingTieRight() {
        for (int i = 0; i < 14; ++i) {
            for (int j = 0; j < 14 - i; ++j) {
                double d = this.getHeight() / 2 + i * 30 / 2 - 210 + j * 30;
                double d2 = (double)(this.getWidth() - i * 12) - 144.0 - 30.0;
                GRect gRect = new GRect(d2, d, 30.0, 12.0);
                gRect.setColor(this.rgen.nextColor());
                gRect.setFilled(true);
                this.add((GObject)gRect);
            }
        }
    }

    private void tieCenter() {
        double d = this.getWidth() / 2;
        double d2 = this.getHeight() / 2;
        this.drawCircle(d, d2, 72.0);
        this.drawCircle(d, d2, 46.800000000000004);
        this.drawCircle(d, d2, 21.599999999999998);
    }

    private void drawCircle(double d, double d2, double d3) {
        double d4 = d - d3;
        double d5 = d2 - d3;
        GOval gOval = new GOval(2.0 * d3, 2.0 * d3);
        gOval.setColor(this.rgen.nextColor());
        gOval.setFilled(true);
        this.add((GObject)gOval, d4, d5);
    }

    private void artistryBy() {
        GLabel gLabel = new GLabel("Artistry by Hussain");
        double d = (double)this.getWidth() - gLabel.getWidth() - gLabel.getWidth() / 50.0;
        double d2 = (double)this.getHeight() - gLabel.getAscent() / 5.0;
        gLabel.setColor(Color.blue);
        this.add((GObject)gLabel, d, d2);
    }

    private void meetTieFighter() {
        GLabel gLabel = new GLabel("Meet the Tie Fighter:");
        double d = (double)(this.getWidth() / 2) - gLabel.getWidth() + gLabel.getWidth() / 10.0;
        double d2 = (double)(this.getHeight() / 4) - gLabel.getAscent();
        gLabel.setColor(Color.darkGray);
        gLabel.setFont("Helvetica-23-bold");
        this.add((GObject)gLabel, d, d2);
    }
}

