/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPolygon;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final int CEILING_MAJOR_AXIS = 150;
    private static final int CEILING_MINOR_AXIS = 75;
    private static final int FACADE_SIDE = 500;
    private static final int PILLAR_HEIGHT = 200;
    private static final int PILLAR_WIDTH = 25;

    public void run() {
        this.drawCeiling();
        this.drawFacade();
        this.drawPillars();
        this.addInscription();
        this.drawGround();
        this.signature();
    }

    private void drawCeiling() {
        double d = this.getWidth() / 2 - 150;
        double d2 = this.getHeight() / 70 + 75;
        GOval gOval = new GOval(300.0, 150.0);
        gOval.setColor(Color.DARK_GRAY);
        gOval.setFilled(true);
        this.add((GObject)gOval, d, d2);
    }

    private void drawFacade() {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(-250.0, 0.0);
        gPolygon.addVertex(0.0, -150.0);
        gPolygon.addVertex(250.0, 0.0);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(Color.GRAY);
        this.add((GObject)gPolygon, this.getWidth() / 2, this.getHeight() / 2);
    }

    private void drawPillars() {
        for (int i = 0; i < 8; ++i) {
            double d = (double)(this.getWidth() / 2 - 250) + (double)i * 67.9;
            double d2 = this.getHeight() / 2;
            GRect gRect = new GRect(d, d2, 25.0, 200.0);
            gRect.setFilled(true);
            gRect.setFillColor(Color.GRAY);
            this.add((GObject)gRect);
        }
    }

    private void addInscription() {
        GLabel gLabel = new GLabel("M.AGRIPPA.L.F.COS.TERTIUM.FECIT");
        gLabel.setFont("Herculanum-24");
        double d = ((double)this.getWidth() - gLabel.getWidth()) / 2.0;
        double d2 = ((double)this.getHeight() - gLabel.getHeight()) / 2.0;
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }

    private void drawGround() {
        GLine gLine = new GLine((double)(this.getWidth() / 2 - 250), (double)(this.getHeight() / 2 + 200), (double)(this.getWidth() / 2 + 250), (double)(this.getHeight() / 2 + 200));
        this.add((GObject)gLine);
    }

    private void signature() {
        GLabel gLabel = new GLabel("Artistry by Jacob Kovacs-Goodman");
        this.add((GObject)gLabel, (double)this.getWidth() - gLabel.getWidth(), this.getHeight());
    }
}

