/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GArc;
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final int BODY_WIDTH = 150;
    private static final int BODY_HEIGHT = 150;
    private static final int EYE_RADIUS = 10;
    private static final int TENTACLE_HEIGHT = 30;
    private static final int NUM_TENTACLES = 4;
    private static final int WAVE_WIDTH = 100;
    private static final int WAVE_HEIGHT = 30;
    private static final int NUM_WAVES = 10;

    public void run() {
        double d = this.getWidth() / 2;
        double d2 = this.getHeight() / 2;
        this.addBody(d, d2);
        this.addEye(d - 37.0, d2 - 37.0);
        this.addEye(d + 37.0, d2 - 37.0);
        this.addTentacles(d - 75.0, d2);
        this.addWater(d, (d2 + (double)this.getHeight()) / 2.0);
        this.addSignature();
    }

    private void addBody(double d, double d2) {
        double d3 = d - 75.0;
        double d4 = d2 - 75.0;
        GArc gArc = new GArc(d3, d4, 150.0, 150.0, 0.0, 180.0);
        this.add((GObject)gArc);
        gArc.setFilled(true);
        gArc.setColor(Color.PINK);
    }

    private void addEye(double d, double d2) {
        double d3 = d - 10.0;
        double d4 = d2 - 10.0;
        GOval gOval = new GOval(d3, d4, 20.0, 20.0);
        gOval.setFilled(true);
        gOval.setColor(Color.WHITE);
        this.add((GObject)gOval);
    }

    private void addTentacles(double d, double d2) {
        for (int i = 0; i < 4; ++i) {
            GLine gLine = new GLine(d, d2, d, d2 + 30.0);
            gLine.setColor(Color.PINK);
            this.add((GObject)gLine);
            d += 50.0;
        }
    }

    private void addWater(double d, double d2) {
        double d3 = d - 500.0;
        double d4 = d2 - 15.0;
        for (int i = 0; i < 10; ++i) {
            GArc gArc = new GArc(d3, d4, 100.0, 30.0, 0.0, 180.0);
            gArc.setFilled(true);
            gArc.setColor(Color.CYAN);
            this.add((GObject)gArc);
            d3 += 100.0;
        }
    }

    private void addSignature() {
        GLabel gLabel = new GLabel("Artistry by Kamakshi Duvvuru");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getHeight();
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }
}

