/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double STEM_WIDTH = 50.0;
    private static final double STEM_HEIGHT = 200.0;
    private static final double LEAF_WIDTH = 40.0;
    private static final double LEAF_HEIGHT = 20.0;
    private double x;
    private double y;
    private static final double SUN_DIAMETER = 200.0;

    public void run() {
        this.drawStem();
        this.drawLeaf(this.x - 40.0, this.y + 50.0);
        this.drawLeaf(this.x + 50.0, this.y + 80.0);
        this.drawCenter();
        this.drawCirclePetal(this.x - 40.0, this.y - 50.0 - 20.0);
        this.drawCirclePetal(this.x - 40.0, this.y - 132.0);
        this.drawCirclePetal(this.x + 40.0, this.y - 50.0 - 20.0);
        this.drawCirclePetal(this.x + 40.0, this.y - 132.0);
        this.drawPetalVertical(this.x, this.y - 50.0);
        this.drawPetalHorizontal(this.x - 80.0, this.y - 100.0);
        this.drawPetalVertical(this.x, this.y - 100.0 - 80.0);
        this.drawPetalHorizontal(this.x + 50.0, this.y - 100.0);
        this.drawSun();
        this.drawSunStripe(0.0, 100.0, 66.66666666666667, 200.0);
        this.drawSunStripe(71.42857142857143, 71.42857142857143, 171.42857142857142, 171.42857142857142);
        this.drawSunStripe(100.0, 0.0, 200.0, 66.66666666666667);
        this.artistryByMe();
    }

    private void drawStem() {
        this.x = (double)(this.getWidth() / 2) - 25.0;
        this.y = (double)this.getHeight() - 200.0;
        GRect gRect = new GRect(this.x, this.y, 50.0, 200.0);
        gRect.setFilled(true);
        gRect.setColor(Color.GREEN);
        this.add((GObject)gRect);
    }

    private void drawLeaf(double d, double d2) {
        GOval gOval = new GOval(d, d2, 40.0, 20.0);
        gOval.setFilled(true);
        gOval.setColor(Color.GREEN);
        this.add((GObject)gOval);
    }

    private void drawCenter() {
        GOval gOval = new GOval(this.x, this.y - 100.0, 50.0, 50.0);
        gOval.setFilled(true);
        gOval.setColor(Color.YELLOW);
        this.add((GObject)gOval);
    }

    private void drawPetalVertical(double d, double d2) {
        GOval gOval = new GOval(d, d2, 50.0, 80.0);
        gOval.setFilled(true);
        gOval.setColor(Color.RED);
        this.add((GObject)gOval);
    }

    private void drawPetalHorizontal(double d, double d2) {
        GOval gOval = new GOval(d, d2, 80.0, 50.0);
        gOval.setFilled(true);
        gOval.setColor(Color.RED);
        this.add((GObject)gOval);
    }

    private void drawCirclePetal(double d, double d2) {
        GOval gOval = new GOval(d, d2, 50.0, 50.0);
        gOval.setFilled(true);
        gOval.setColor(Color.PINK);
        this.add((GObject)gOval);
    }

    private void drawSun() {
        GOval gOval = new GOval(-100.0, -100.0, 200.0, 200.0);
        gOval.setFilled(true);
        gOval.setColor(Color.YELLOW);
        this.add((GObject)gOval);
    }

    private void drawSunStripe(double d, double d2, double d3, double d4) {
        GLine gLine = new GLine(d, d2, d3, d4);
        gLine.setColor(Color.ORANGE);
        this.add((GObject)gLine);
    }

    private void artistryByMe() {
        GLabel gLabel = new GLabel("Artistry by Karen Scrivner");
        gLabel.setFont("SansSerif-12");
        gLabel.setColor(Color.MAGENTA);
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getAscent();
        this.add((GObject)gLabel, d, d2);
    }
}

