/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double STEM_LENGTH = 200.0;
    private static final double STEM_HEIGHT = 30.0;
    private static final Color STEM_COLOR = Color.black;
    private static final double BOTTOM_HEIGHT = 90.0;
    private static final double BOTTOM_WIDTH = 60.0;
    private static final Color BOTTOM_COLOR = Color.gray;
    private static final double TOP_HEIGHT = 20.0;
    private static final double TOP_WIDTH = 60.0;
    private static final Color TOP_COLOR = Color.ORANGE;
    private static final double THIS_X = 300.0;
    private static final double THIS_Y = 300.0;
    private static final Color THIS_COLOR = Color.red;
    private static final double IS_NOT_X = 400.0;
    private static final double IS_NOT_Y = 320.0;
    private static final Color IS_NOT_COLOR = Color.blue;
    private static final double A_PIPE_X = 500.0;
    private static final double A_PIPE_Y = 350.0;
    private static final Color A_PIPE_COLOR = Color.red;

    public void run() {
        this.drawPipe();
        this.drawLabels();
        this.signature();
    }

    private void drawPipe() {
        this.drawStem();
        this.drawBowl();
    }

    private void drawStem() {
        double d = (double)(this.getWidth() / 2) - 100.0;
        double d2 = (double)(this.getHeight() / 2) - 15.0;
        GRect gRect = new GRect(d, d2, 200.0, 30.0);
        gRect.setFilled(true);
        gRect.setFillColor(STEM_COLOR);
        this.add((GObject)gRect);
    }

    private void drawBowl() {
        this.drawBottom();
        this.drawTop();
    }

    private void drawBottom() {
        double d = (double)(this.getWidth() / 2) + 100.0;
        double d2 = (double)(this.getHeight() / 2) + 15.0 - 90.0;
        GRect gRect = new GRect(d, d2, 60.0, 90.0);
        gRect.setFilled(true);
        gRect.setFillColor(BOTTOM_COLOR);
        this.add((GObject)gRect);
    }

    private void drawTop() {
        double d = (double)(this.getWidth() / 2) + 100.0;
        double d2 = (double)(this.getHeight() / 2) + 15.0 - 90.0 - 10.0;
        GOval gOval = new GOval(d, d2, 60.0, 20.0);
        gOval.setFilled(true);
        gOval.setFillColor(TOP_COLOR);
        this.add((GObject)gOval);
    }

    private void drawLabels() {
        this.drawThis();
        this.drawIsNot();
        this.drawAPipe();
    }

    private void drawThis() {
        GLabel gLabel = new GLabel("This", 300.0, 300.0);
        gLabel.setFont("Serif-20");
        gLabel.setColor(THIS_COLOR);
        this.add((GObject)gLabel);
    }

    private void drawIsNot() {
        GLabel gLabel = new GLabel("is not", 400.0, 320.0);
        gLabel.setFont("Serif-16");
        gLabel.setColor(IS_NOT_COLOR);
        this.add((GObject)gLabel);
    }

    private void drawAPipe() {
        GLabel gLabel = new GLabel("a pipe.", 500.0, 350.0);
        gLabel.setFont("Serif-20");
        gLabel.setColor(A_PIPE_COLOR);
        this.add((GObject)gLabel);
    }

    private void signature() {
        double d = this.getWidth() - 5;
        double d2 = this.getHeight() - 5;
        GLabel gLabel = new GLabel("Artistry by Kate Mayer", d, d2);
        gLabel.setLocation(d -= gLabel.getWidth(), d2);
        this.add((GObject)gLabel);
    }
}

