/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double STAR_RADIUS = 50.0;
    private static final int NUM_STAR_POINTS = 7;
    private static final int SECOND_NUM_STAR_POINTS = 10;
    private static final int THIRD_NUM_STAR_POINTS = 7;
    private static final int BRICK_WIDTH = 40;
    private static final int BRICK_HEIGHT = 20;
    private static final int BRICKS_IN_BASE = 16;

    public void run() {
        GRect gRect = new GRect(0.0, 0.0, (double)this.getWidth(), (double)this.getHeight());
        gRect.setFillColor(Color.BLACK);
        gRect.setFilled(true);
        this.add((GObject)gRect);
        for (int i = 16; i > 7; --i) {
            int n = this.getHeight() - (16 - i + 1) * 20;
            this.fillRow(n, i);
        }
        double d = 0.25 * (double)this.getWidth();
        double d2 = 0.4 * (double)this.getHeight();
        double d3 = 0.5 * (double)this.getWidth();
        double d4 = 0.2 * (double)this.getHeight();
        double d5 = 0.75 * (double)this.getWidth();
        double d6 = 0.4 * (double)this.getHeight();
        this.drawStar(d, d2, 7.0);
        this.drawStar(d3, d4, 10.0);
        this.drawStar(d5, d6, 7.0);
        this.createSignature();
    }

    private void fillRow(int n, int n2) {
        int n3 = this.getWidth() / 2 - n2 * 40 / 2;
        for (int i = 0; i < n2; ++i) {
            GRect gRect = new GRect((double)(n3 + i * 40), (double)n, 40.0, 20.0);
            if (i % 3 == 0) {
                gRect.setFilled(true);
                gRect.setFillColor(Color.DARK_GRAY);
            } else {
                gRect.setFilled(true);
                gRect.setFillColor(Color.GRAY);
            }
            this.add((GObject)gRect);
        }
    }

    private void drawStar(double d, double d2, double d3) {
        GOval gOval = new GOval(d - 50.0, d2 - 50.0, 100.0, 100.0);
        gOval.setColor(Color.LIGHT_GRAY);
        gOval.setFillColor(Color.LIGHT_GRAY);
        gOval.setFilled(true);
        this.add((GObject)gOval);
        int n = 0;
        while ((double)n < d3) {
            double d4 = (double)(n * 2) * Math.PI / d3;
            double d5 = (double)((n + 2) * 2) * Math.PI / d3;
            GLine gLine = new GLine(d + 50.0 * Math.cos(d4), d2 - 50.0 * Math.sin(d4), d + 50.0 * Math.cos(d5), d2 - 50.0 * Math.sin(d5));
            gLine.setColor(Color.YELLOW);
            this.add((GObject)gLine);
            ++n;
        }
    }

    private void createSignature() {
        GLabel gLabel = new GLabel("'Artistry' by Kevin");
        gLabel.setFont("Arial-Bold-20");
        gLabel.setColor(Color.white);
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = gLabel.getHeight();
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }
}

