/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final int GROUND_HEIGHT = 30;
    private static final int PETAL_RADIUS = 30;
    private static final int CENTER_RADIUS = 30;
    private static final int PETAL_COUNT = 4;

    public void run() {
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = d / 2.0;
        double d4 = d2 / 2.0;
        double d5 = 90.0;
        this.addStem(d3, d4, d, d2);
        this.addGround(d, d2);
        this.addTopLeftPetal(d3, d4);
        this.addTopRightPetal(d3, d4);
        this.addBottomLeftPetal(d3, d4);
        this.addBottomRightPetal(d3, d4);
        this.addCenter(d3, d4);
        this.addSignature(d, d2);
    }

    private void addStem(double d, double d2, double d3, double d4) {
        GLine gLine = new GLine(d, d2, d, d4);
        gLine.setColor(Color.MAGENTA);
        this.add((GObject)gLine);
    }

    private void addGround(double d, double d2) {
        double d3 = d2 - 30.0;
        GRect gRect = new GRect(0.0, d3, d, d2);
        gRect.setFilled(true);
        gRect.setColor(Color.GREEN);
        this.add((GObject)gRect);
    }

    private void addTopLeftPetal(double d, double d2) {
        double d3 = d - 60.0;
        double d4 = d2 - 60.0;
        this.drawCircle(d3, d4, 30.0, Color.PINK);
    }

    private void addTopRightPetal(double d, double d2) {
        double d3 = d;
        double d4 = d2 - 60.0;
        this.drawCircle(d3, d4, 30.0, Color.PINK);
    }

    private void addBottomLeftPetal(double d, double d2) {
        double d3 = d - 60.0;
        double d4 = d2;
        this.drawCircle(d3, d4, 30.0, Color.PINK);
    }

    private void addBottomRightPetal(double d, double d2) {
        double d3 = d;
        double d4 = d2;
        this.drawCircle(d3, d4, 30.0, Color.PINK);
    }

    private void addCenter(double d, double d2) {
        double d3 = d - 30.0;
        double d4 = d2 - 30.0;
        this.drawCircle(d3, d4, 30.0, Color.YELLOW);
    }

    private void drawCircle(double d, double d2, double d3, Color color) {
        GOval gOval = new GOval(2.0 * d3, 2.0 * d3);
        gOval.setColor(color);
        gOval.setFilled(true);
        this.add((GObject)gOval, d, d2);
    }

    private void addSignature(double d, double d2) {
        GLabel gLabel = new GLabel("Artistry by Kellee", d - 100.0, d2 - 10.0);
        gLabel.setFont("SansSerif");
        gLabel.setColor(Color.BLACK);
        this.add((GObject)gLabel);
    }
}

