/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double SUN_ON_HORIZON = 0.0;
    private static final double SUN_RISE_INCREMENT = 30.0;
    private static final double PAUSE_TIME = 500.0;
    private static final double SUN_RISEN = 100.0;
    private static final double MOON_IN_SKY = 0.0;
    private static final double MOON_SET_INCREMENT = 30.0;
    private static final double STEM_GROW_INCREMENT = 15.0;
    private static final double STEM_GROWN = 50.0;
    private static final double FLOWER_DIAMETER1 = 20.0;
    private static final double FLOWER_DIAMETER2 = 50.0;
    private static final double DIAMETER_GROW_INCREMENT = 10.0;
    private static final double STEM_WIDTH = 10.0;

    public void run() {
        this.add((GObject)this.night());
        this.moonSet();
        this.pause(500.0);
        this.add((GObject)this.day());
        this.pause(500.0);
        this.sunRise();
        this.addGrass();
        this.pause(1000.0);
        this.flowerGrow();
        this.pause(1000.0);
        this.addName();
    }

    private GRect night() {
        GRect gRect = new GRect(0.0, 0.0, (double)this.getWidth(), (double)this.getHeight());
        gRect.setFilled(true);
        gRect.setFillColor(Color.BLACK);
        return gRect;
    }

    private void moonSet() {
        GOval gOval = this.createMoon();
        this.add((GObject)gOval);
        this.moonSet(gOval);
    }

    private GOval createMoon() {
        GOval gOval = new GOval((double)(3 * this.getWidth() / 4), (double)(this.getHeight() / 4), 60.0, 60.0);
        gOval.setFilled(true);
        gOval.setFillColor(Color.WHITE);
        gOval.setColor(Color.WHITE);
        return gOval;
    }

    private void moonSet(GOval gOval) {
        double d = 0.0;
        double d2 = 0.0;
        while (this.moonNotDown(gOval)) {
            gOval.move(d, d2);
            d2 += 30.0;
            this.pause(500.0);
        }
    }

    private boolean moonNotDown(GOval gOval) {
        return gOval.getY() < (double)this.getHeight();
    }

    private GRect day() {
        GRect gRect = new GRect(0.0, 0.0, (double)this.getWidth(), (double)this.getHeight());
        gRect.setFilled(true);
        gRect.setFillColor(Color.BLUE);
        return gRect;
    }

    private void sunRise() {
        GOval gOval = this.createSun();
        this.add((GObject)gOval);
        this.sunRise(gOval);
    }

    private GOval createSun() {
        GOval gOval = new GOval((double)(3 * this.getWidth() / 4), (double)this.getHeight(), 60.0, 60.0);
        gOval.setFilled(true);
        gOval.setFillColor(Color.YELLOW);
        gOval.setColor(Color.YELLOW);
        return gOval;
    }

    private void sunRise(GOval gOval) {
        double d = 0.0;
        double d2 = 0.0;
        while (this.sunNotRisen(gOval)) {
            gOval.move(d, d2);
            d2 -= 30.0;
            this.pause(500.0);
        }
    }

    private boolean sunNotRisen(GOval gOval) {
        return gOval.getY() > 100.0;
    }

    private void addGrass() {
        GRect gRect = new GRect(0.0, (double)(this.getHeight() / 2), (double)this.getWidth(), (double)(this.getHeight() / 2));
        gRect.setFilled(true);
        gRect.setFillColor(Color.GREEN);
        this.add((GObject)gRect);
    }

    private void flowerGrow() {
        this.addStem();
        this.addHead();
    }

    private void addStem() {
        GRect gRect = this.createStem();
        this.add((GObject)gRect);
        this.stemGrow(gRect);
    }

    private GRect createStem() {
        GRect gRect = new GRect((double)(this.getWidth() / 2), (double)(this.getHeight() / 2), 10.0, 10.0);
        gRect.setFilled(true);
        gRect.setFillColor(Color.YELLOW);
        gRect.setColor(Color.YELLOW);
        return gRect;
    }

    private void stemGrow(GRect gRect) {
        double d = 10.0;
        double d2 = 0.0;
        double d3 = this.getHeight() / 2;
        double d4 = this.getWidth() / 2;
        while (this.stemNotGrown(gRect)) {
            gRect.setSize(d, d2);
            d2 += 15.0;
            gRect.setLocation(d4, d3);
            d3 -= 15.0;
            this.pause(500.0);
        }
    }

    private boolean stemNotGrown(GRect gRect) {
        return gRect.getHeight() < 50.0;
    }

    private void addHead() {
        GOval gOval = this.createHead();
        this.add((GObject)gOval);
        this.headBloom(gOval);
    }

    private GOval createHead() {
        double d = (double)(this.getWidth() / 2) - 10.0 + 5.0;
        double d2 = (double)(this.getHeight() / 2) - 50.0 - 20.0;
        GOval gOval = new GOval(d, d2, 20.0, 20.0);
        gOval.setFilled(true);
        gOval.setFillColor(Color.RED);
        gOval.setColor(Color.RED);
        return gOval;
    }

    private void headBloom(GOval gOval) {
        double d = 20.0;
        double d2 = (double)(this.getWidth() / 2) - 10.0 + 5.0;
        double d3 = (double)(this.getHeight() / 2) - 50.0 - 20.0;
        while (this.headNotBloom(gOval)) {
            gOval.setSize(d, d);
            d += 10.0;
            gOval.setLocation(d2, d3);
            d2 -= 5.0;
            d3 -= 5.0;
            this.pause(500.0);
        }
    }

    private boolean headNotBloom(GOval gOval) {
        return gOval.getHeight() < 50.0;
    }

    private void addName() {
        double d = this.getWidth();
        double d2 = this.getHeight();
        GLabel gLabel = new GLabel("Laura Griffiths", 100.0, 75.0);
        gLabel.setFont("Purisa-ITALIC-16");
        gLabel.setColor(Color.BLACK);
        gLabel.setLocation(d - gLabel.getWidth(), d2 - gLabel.getHeight());
        this.add((GObject)gLabel);
    }
}

