/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    public static final double BIG_OVAL_HEIGHT = 250.0;
    public static final double BIG_OVAL_WIDTH = 450.0;
    public static final double SMALL_OVAL_HEIGHT = 200.0;
    public static final double SMALL_OVAL_WIDTH = 150.0;

    public void run() {
        this.drawArt();
        this.signArtistry();
    }

    private void drawArt() {
        int n;
        double d = this.getWidth() / 2;
        double d2 = this.getHeight() / 2;
        this.add((GObject)this.createFilledOval(d, d2, this.getHeight(), this.getWidth(), Color.YELLOW));
        this.add((GObject)this.createFilledOval(d, d2, 250.0, 450.0, Color.GREEN));
        this.add((GObject)this.createFilledOval(d, d2, 200.0, 150.0, Color.BLUE));
        this.add((GObject)this.createOval(d, d2, 250.0, 150.0, Color.PINK));
        this.add((GObject)this.createOval(d, d2, 450.0, 150.0, Color.MAGENTA));
        this.add((GObject)this.createOval(d, d2, 300.0, 500.0, Color.ORANGE));
        this.add((GObject)this.createOval(d, d2, 100.0, 225.0, Color.WHITE));
        for (n = 0; n < 5; ++n) {
            this.add((GObject)this.createRect(d, d2, 400.0 + (double)(10 * n), 300.0 + (double)(10 * n), Color.PINK));
        }
        for (n = 0; n < 4; ++n) {
            this.add((GObject)this.createLine(0.0, n * this.getHeight() / 3, this.getWidth(), n * this.getHeight() / 3, Color.CYAN));
        }
    }

    private GOval createFilledOval(double d, double d2, double d3, double d4, Color color) {
        GOval gOval = new GOval(d - d4 / 2.0, d2 - d3 / 2.0, d4, d3);
        gOval.setColor(color);
        gOval.setFilled(true);
        return gOval;
    }

    private GOval createOval(double d, double d2, double d3, double d4, Color color) {
        GOval gOval = new GOval(d - d4 / 2.0, d2 - d3 / 2.0, d4, d3);
        gOval.setColor(color);
        return gOval;
    }

    private GRect createRect(double d, double d2, double d3, double d4, Color color) {
        GRect gRect = new GRect(d - d4 / 2.0, d2 - d3 / 2.0, d4, d3);
        gRect.setColor(color);
        return gRect;
    }

    private GLine createLine(double d, double d2, double d3, double d4, Color color) {
        GLine gLine = new GLine(d, d2, d3, d4);
        gLine.setColor(color);
        return gLine;
    }

    private void signArtistry() {
        GLabel gLabel = new GLabel("Laura Swenson");
        gLabel.setFont("Apple Chancery-14");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getAscent() - gLabel.getDescent();
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }
}

