/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final int PETAL_MAJOR = 100;
    private static final int PETAL_MINOR = 50;
    private static final int OFFSET = 10;
    private static final int ROUNDNESS = 50;
    private static final int LEAF_SIZE = 20;

    public void run() {
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        int n3 = this.getHeight() * 15 / 16;
        this.drawFlower(n, n2, Color.RED);
        this.drawLeaf(n, n3);
        GLine gLine = new GLine((double)n, (double)(n2 + 50 + 25 + 10), (double)n, (double)this.getHeight());
        this.add((GObject)gLine);
        this.signName();
    }

    private void drawLeaf(int n, int n2) {
        GRect gRect = new GRect((double)n, (double)(n2 - 20), 30.0, 20.0);
        gRect.setColor(Color.GREEN);
        gRect.setFilled(true);
        this.add((GObject)gRect);
        this.shapeLeaf(n, n2);
    }

    private void shapeLeaf(int n, int n2) {
        GOval gOval = new GOval(20.0, 20.0);
        gOval.setColor(Color.WHITE);
        gOval.setFilled(true);
        this.add((GObject)gOval, n - 10, n2 - 25);
        GOval gOval2 = new GOval(30.0, 10.0);
        gOval2.setColor(Color.WHITE);
        gOval2.setFilled(true);
        this.add((GObject)gOval2, n + 5, n2 - 5);
    }

    private void drawFlower(int n, int n2, Color color) {
        int n3 = n + 10;
        int n4 = n2 + 10;
        int n5 = n - 10 - 50;
        int n6 = n2 - 10 - 50;
        int n7 = n2 - 25;
        int n8 = n - 25;
        this.drawPetalRight(n3, n7, color);
        this.drawPetalLeft(n5, n7, color);
        this.drawPetalTop(n8, n6, color);
        this.drawPetalBottom(n8, n4, color);
    }

    private void drawPetalRight(int n, int n2, Color color) {
        this.hemisphereWest(n, n2, 100, 50, color);
        this.roundEdge(n - 25 + 50, n2, 50, 50, color);
    }

    private void drawPetalLeft(int n, int n2, Color color) {
        this.hemisphereEast(n, n2, 100, 50, color);
        this.roundEdge(n - 25, n2, 50, 50, color);
    }

    private void drawPetalTop(int n, int n2, Color color) {
        this.hemisphereSouth(n, n2, 50, 100, color);
        this.roundEdge(n, n2 - 25, 50, 50, color);
    }

    private void drawPetalBottom(int n, int n2, Color color) {
        this.hemisphereNorth(n, n2, 50, 100, color);
        this.roundEdge(n, n2 + 50 - 25, 50, 50, color);
    }

    private void roundEdge(int n, int n2, int n3, int n4, Color color) {
        GOval gOval = new GOval((double)n3, (double)n4);
        gOval.setColor(color);
        gOval.setFilled(true);
        this.add((GObject)gOval, n, n2);
    }

    private void hemisphereWest(int n, int n2, int n3, int n4, Color color) {
        this.hemisphere(n, n2, n3, n4, color);
        this.petalEdge(n + n3 / 2, n2, n3 / 2 + 1, n4 + 1);
    }

    private void hemisphereEast(int n, int n2, int n3, int n4, Color color) {
        this.hemisphere(n - n3 / 2, n2, n3, n4, color);
        this.petalEdge(n - n3 / 2, n2, n3 / 2 + 1, n4 + 1);
    }

    private void hemisphereSouth(int n, int n2, int n3, int n4, Color color) {
        this.hemisphere(n, n2 - n4 / 2, n3, n4, color);
        this.petalEdge(n, n2 - n4 / 2, n3 + 1, n4 / 2 + 1);
    }

    private void hemisphereNorth(int n, int n2, int n3, int n4, Color color) {
        this.hemisphere(n, n2, n3, n4, color);
        this.petalEdge(n, n2 + n4 / 2, n3 + 1, n4 / 2 + 1);
    }

    private void petalEdge(int n, int n2, int n3, int n4) {
        GRect gRect = new GRect((double)n3, (double)n4);
        gRect.setColor(Color.WHITE);
        gRect.setFilled(true);
        this.add((GObject)gRect, n, n2);
    }

    private void hemisphere(int n, int n2, int n3, int n4, Color color) {
        GOval gOval = new GOval((double)n3, (double)n4);
        gOval.setColor(color);
        gOval.setFilled(true);
        this.add((GObject)gOval, n, n2);
    }

    private void signName() {
        GLabel gLabel = new GLabel("Artistry by Liliane Hsu");
        gLabel.setFont("Serif-18");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getAscent();
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }
}

