/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPolygon;
import acm.graphics.GRect;
import acm.graphics.GRoundRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double BOAT_POS_Y_OFFSET = 100.0;
    private static final double BOAT_LENGTH = 400.0;
    private static final double BOAT_HEIGHT = 40.0;
    private static final double BOAT_FRONT_ANGLE = 40.0;
    private static final double BOAT_BACK_ANGLE = 15.0;
    private static final double KEEL_POS_FROM_FRONT = 150.0;
    private static final double KEEL_LENGTH = 50.0;
    private static final double KEEL_DEPTH = 65.0;
    private static final double KEEL_ANGLE = 10.0;
    private static final double RUDDER_WIDTH = 20.0;
    private static final double RUDDER_DEPTH = 40.0;
    private static final double RUDDER_OFFSET = 5.0;
    private static final double CABIN_POS = 150.0;
    private static final double CABIN_LENGTH = 200.0;
    private static final double CABIN_HEIGHT = 15.0;
    private static final double MAST_POS = 220.0;
    private static final double MAST_WIDTH = 5.0;
    private static final double MAST_HEIGHT = 270.0;
    private static final double MAIN_OFFSET = 15.0;
    private static final double MAIN_FOOT = 150.0;
    private static final double JIB_HEIGHT_OFFSET = 250.0;
    private static final double SUN_X_OFFSET = 300.0;
    private static final double SUN_Y_OFFSET = 300.0;
    private static final double SUN_SIZE = 75.0;
    private static final double WAVE_SIZE = 35.0;
    private static final double WAVE_OFFSET = 25.0;
    private static final double BOAT_NAME_X_OFFSET = 20.0;
    private static final double BOAT_NAME_Y_OFFSET = 15.0;
    private static final double SAIL_NUM_X_OFFSET = 32.0;
    private static final double SAIL_NUM_Y_OFFSET = 170.0;

    public void run() {
        double d = this.getWidth() / 2;
        double d2 = (double)(this.getHeight() / 2) + 100.0;
        this.drawWaves(d, d2);
        this.drawBoat(d, d2);
        this.drawSails(d, d2);
        this.drawSun(d, d2);
        this.drawSignature();
    }

    private void drawWaves(double d, double d2) {
        for (int i = 0; i < 30; ++i) {
            GOval gOval = new GOval(0.0 + (double)i * 25.0, d2 - 20.0, 35.0, 35.0);
            gOval.setColor(Color.BLUE);
            gOval.setFilled(false);
            this.add((GObject)gOval);
        }
        GRect gRect = new GRect(0.0, d2 - 24.0, d * 2.0, 35.0);
        gRect.setColor(Color.WHITE);
        gRect.setFilled(true);
        this.add((GObject)gRect);
    }

    private void drawBoat(double d, double d2) {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(d - 200.0, d2 - 20.0);
        gPolygon.addEdge(400.0, 0.0);
        gPolygon.addEdge(-15.0, 40.0);
        gPolygon.addEdge(-345.0, 0.0);
        gPolygon.setColor(Color.RED);
        gPolygon.setFilled(true);
        this.add((GObject)gPolygon);
        GPolygon gPolygon2 = new GPolygon();
        gPolygon2.addVertex(d - 200.0 + 40.0 + 150.0, d2 - 20.0 + 40.0);
        gPolygon2.addEdge(50.0, 0.0);
        gPolygon2.addEdge(0.0, 65.0);
        gPolygon2.addEdge(-30.0, 0.0);
        gPolygon2.setColor(Color.RED);
        gPolygon2.setFilled(true);
        this.add((GObject)gPolygon2);
        GRoundRect gRoundRect = new GRoundRect(d - 200.0 + 400.0 - 15.0 - 20.0, d2 - 20.0 + 40.0 - 5.0, 20.0, 40.0);
        gRoundRect.setColor(Color.RED);
        gRoundRect.setFilled(true);
        this.add((GObject)gRoundRect);
        GRect gRect = new GRect(d - 200.0 + 150.0, d2 - 20.0 - 15.0, 200.0, 15.0);
        gRect.setColor(Color.BLUE);
        gRect.setFilled(true);
        this.add((GObject)gRect);
        GLabel gLabel = new GLabel("JAVA");
        gLabel.setFont("GoudyStout-14");
        gLabel.setColor(Color.GREEN);
        gLabel.setLocation(d - 200.0 + 20.0, d2 - 20.0 + 15.0);
        this.add((GObject)gLabel);
    }

    private void drawSails(double d, double d2) {
        GRect gRect = new GRect(d - 200.0 + 220.0, d2 - 20.0 - 270.0 - 15.0, 5.0, 270.0);
        gRect.setColor(Color.BLACK);
        gRect.setFilled(true);
        this.add((GObject)gRect);
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(d - 200.0 + 220.0, d2 - 20.0 - 270.0 - 15.0);
        gPolygon.addEdge(150.0, 255.0);
        gPolygon.addEdge(-150.0, 0.0);
        gPolygon.setFilled(false);
        this.add((GObject)gPolygon);
        GPolygon gPolygon2 = new GPolygon();
        gPolygon2.addVertex(d - 200.0, d2 - 20.0);
        gPolygon2.addEdge(220.0, -285.0);
        gPolygon2.addEdge(-55.0, 250.0);
        gPolygon2.setFilled(false);
        this.add((GObject)gPolygon2);
        GLabel gLabel = new GLabel("CS106A");
        gLabel.setFont("ArialBlack-14");
        gLabel.setLocation(d + 32.0, d2 - 170.0);
        this.add((GObject)gLabel);
    }

    private void drawSun(double d, double d2) {
        GOval gOval = new GOval(d - 300.0, d2 - 300.0, 75.0, 75.0);
        gOval.setColor(Color.YELLOW);
        gOval.setFilled(true);
        this.add((GObject)gOval);
    }

    private void drawSignature() {
        GLabel gLabel = new GLabel("Artistry by Matt Roberts");
        gLabel.setFont("HarlowSolidItalic-18");
        gLabel.setLocation((double)this.getWidth() - gLabel.getWidth(), (double)this.getHeight() - gLabel.getDescent());
        this.add((GObject)gLabel);
    }
}

