/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GArc;
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double RADIUS_FRACTION = 6.0;

    public void run() {
        double d = this.getHeight() >= this.getWidth() ? (double)this.getWidth() / 6.0 : (double)this.getHeight() / 6.0;
        this.draw_flower_of_life(d, this.getWidth() / 2, this.getHeight() / 2);
        this.sign_name();
    }

    private void draw_flower_of_life(double d, double d2, double d3) {
        this.add((GObject)this.make_background(2.0 * d, d2, d3));
        this.draw_full_circles(d, d2, d3);
        this.draw_semi_circles(d, d2, d3);
        this.draw_third_circles(d, d2, d3);
    }

    private void draw_full_circles(double d, double d2, double d3) {
        this.add((GObject)this.make_blue_edged_circle(d, d2, d3));
        this.add((GObject)this.make_blue_edged_circle(d, d2, d3 - d));
        this.add((GObject)this.make_blue_edged_circle(d, d2, d3 + d));
        this.add((GObject)this.make_blue_edged_circle(d, d2 + d * Math.sqrt(3.0) / 2.0, d3 - d / 2.0));
        this.add((GObject)this.make_blue_edged_circle(d, d2 + d * Math.sqrt(3.0) / 2.0, d3 + d / 2.0));
        this.add((GObject)this.make_blue_edged_circle(d, d2 - d * Math.sqrt(3.0) / 2.0, d3 - d / 2.0));
        this.add((GObject)this.make_blue_edged_circle(d, d2 - d * Math.sqrt(3.0) / 2.0, d3 + d / 2.0));
    }

    private void draw_semi_circles(double d, double d2, double d3) {
        this.add((GObject)this.make_blue_edged_arc(d, d2 + d * Math.sqrt(3.0), d3, 90.0, 180.0));
        this.add((GObject)this.make_blue_edged_arc(d, d2 + d * Math.sqrt(3.0) / 2.0, d3 - 3.0 * d / 2.0, 150.0, 180.0));
        this.add((GObject)this.make_blue_edged_arc(d, d2 - d * Math.sqrt(3.0) / 2.0, d3 - 3.0 * d / 2.0, 210.0, 180.0));
        this.add((GObject)this.make_blue_edged_arc(d, d2 - d * Math.sqrt(3.0), d3, 270.0, 180.0));
        this.add((GObject)this.make_blue_edged_arc(d, d2 - d * Math.sqrt(3.0) / 2.0, d3 + 3.0 * d / 2.0, 330.0, 180.0));
        this.add((GObject)this.make_blue_edged_arc(d, d2 + d * Math.sqrt(3.0) / 2.0, d3 + 3.0 * d / 2.0, 30.0, 180.0));
    }

    private void draw_third_circles(double d, double d2, double d3) {
        this.add((GObject)this.make_blue_edged_arc(d, d2, d3 - 2.0 * d, 210.0, 120.0));
        this.add((GObject)this.make_blue_edged_arc(d, d2 - Math.sqrt(3.0) * d, d3 - d, 270.0, 120.0));
        this.add((GObject)this.make_blue_edged_arc(d, d2 - Math.sqrt(3.0) * d, d3 + d, 330.0, 120.0));
        this.add((GObject)this.make_blue_edged_arc(d, d2, d3 + 2.0 * d, 30.0, 120.0));
        this.add((GObject)this.make_blue_edged_arc(d, d2 + Math.sqrt(3.0) * d, d3 + d, 90.0, 120.0));
        this.add((GObject)this.make_blue_edged_arc(d, d2 + Math.sqrt(3.0) * d, d3 - d, 150.0, 120.0));
    }

    private GArc make_blue_edged_arc(double d, double d2, double d3, double d4, double d5) {
        GArc gArc = new GArc(d2 -= d, d3 -= d, 2.0 * d, 2.0 * d, d4, d5);
        gArc.setColor(Color.blue);
        return gArc;
    }

    private GOval make_blue_edged_circle(double d, double d2, double d3) {
        GOval gOval = new GOval(d2 -= d, d3 -= d, 2.0 * d, 2.0 * d);
        gOval.setColor(Color.blue);
        return gOval;
    }

    private GRect make_background(double d, double d2, double d3) {
        GRect gRect = new GRect(d2 -= Math.sqrt(3.0) * d / 4.0 + d / 2.0, d3 -= d, d + Math.sqrt(3.0) * d / 2.0, 2.0 * d);
        gRect.setColor(Color.blue);
        gRect.setFilled(true);
        gRect.setFillColor(Color.green);
        return gRect;
    }

    private void sign_name() {
        GLabel gLabel = new GLabel("Mark Cuson");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = this.getHeight();
        this.add((GObject)gLabel, d, d2);
    }
}

