/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GArc;
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPolygon;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double CENTER_X = 250.0;
    private static final double CENTER_Y = 150.0;
    private static final double EYE_SIZE = 30.0;
    private static final double PUPIL_SIZE = 5.0;
    private static final double NOSE_WIDTH = 60.0;
    private static final double NOSE_HEIGHT = 15.0;
    private static final double MOUTH_SIZE = 100.0;
    private static final double TOOTH_SIZE = 15.0;
    private static final double BODY_WIDTH = 200.0;
    private static final double BODY_HEIGHT = 300.0;
    private static final double LEG_LENGTH = 80.0;
    private static final double FOOT_LENGTH = 20.0;
    private static final double ARM_LENGTH = 80.0;
    private static final double TIE_WIDTH = 30.0;
    private static final double COLLAR_WIDTH = 18.0;
    private static final double SHIFT = 10.0;

    public void run() {
        this.drawBody();
        this.drawFace();
        this.drawClothes();
        this.drawName();
    }

    private void drawBody() {
        this.addRect(150.0, 75.0, 200.0, 300.0, Color.YELLOW);
        this.addLine(200.0, 375.0, 200.0, 455.0);
        this.addLine(300.0, 375.0, 300.0, 455.0);
        this.addLine(200.0, 455.0, 180.0, 455.0);
        this.addLine(300.0, 455.0, 320.0, 455.0);
        this.addLine(150.0, 210.0, 70.0, 210.0);
        this.addLine(350.0, 210.0, 430.0, 210.0);
    }

    private void drawFace() {
        this.addOval(260.0, 150.0, 30.0, Color.WHITE);
        this.addOval(265.0, 175.0, 5.0, Color.BLACK);
        this.addOval(180.0, 150.0, 30.0, Color.WHITE);
        this.addOval(225.0, 175.0, 5.0, Color.BLACK);
        this.addRect(250.0, 210.0, 60.0, 15.0, Color.YELLOW);
        this.addArc(200.0, 180.0, 100.0, 100.0, -180.0, 180.0);
        this.addRect(231.66666666666666, 230.0, 15.0, 15.0, Color.WHITE);
        this.addRect(253.33333333333334, 230.0, 15.0, 15.0, Color.WHITE);
    }

    private void drawClothes() {
        this.addLine(160.0, 295.0, 340.0, 295.0);
        this.addTri(217.0, 295.0, 18.0, Color.WHITE);
        this.addTri(265.0, 295.0, 18.0, Color.WHITE);
        this.addTri(235.0, 295.0, 30.0, Color.RED);
        this.addDiam(250.0, 310.0, 15.0);
    }

    private void drawName() {
        GLabel gLabel = new GLabel("Artistry by Michael B. Chun");
        gLabel.setFont("Trebuchet MS");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getDescent();
        this.add((GObject)gLabel, d, d2);
    }

    private void addOval(double d, double d2, double d3, Color color) {
        GOval gOval = new GOval(d3 * 2.0, d3 * 2.0);
        gOval.setColor(Color.BLACK);
        gOval.setFilled(true);
        gOval.setFillColor(color);
        this.add((GObject)gOval, d, d2);
    }

    private void addLine(double d, double d2, double d3, double d4) {
        GLine gLine = new GLine(d, d2, d3, d4);
        gLine.setColor(Color.BLACK);
        this.add((GObject)gLine);
    }

    private void addRect(double d, double d2, double d3, double d4, Color color) {
        GRect gRect = new GRect(d, d2, d3, d4);
        gRect.setFilled(true);
        gRect.setFillColor(color);
        this.add((GObject)gRect);
    }

    private void addArc(double d, double d2, double d3, double d4, double d5, double d6) {
        GArc gArc = new GArc(d3, d4, d5, d6);
        gArc.setFilled(true);
        gArc.setFillColor(Color.RED);
        this.add((GObject)gArc, d, d2);
    }

    private void addTri(double d, double d2, double d3, Color color) {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(d, d2);
        gPolygon.addVertex(d + d3, d2);
        gPolygon.addVertex(d + d3 / 2.0, d2 + d3 / 2.0);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(color);
        this.add((GObject)gPolygon);
    }

    private void addDiam(double d, double d2, double d3) {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(d, d2);
        gPolygon.addVertex(d + d3 / 2.0, d2 + d3 * 1.2);
        gPolygon.addVertex(d, d2 + d3 * 2.0);
        gPolygon.addVertex(d - d3 / 2.0, d2 + d3 * 1.2);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(Color.RED);
        this.add((GObject)gPolygon);
    }
}

