/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double HEAD_RADIUS = 60.0;
    private static final double HEAD_Y = 100.0;
    private static final double GAP_HEAD_BODY = 5.0;
    private static final double BODY_HEIGHT = 95.0;
    private static final double GAP_BODY_ARM = 7.0;
    private static final double ARM_WIDTH = 24.0;
    private static final double ARM_HEIGHT = 70.0;
    private static final double LEG_WIDTH = 28.0;
    private static final double LEG_HEIGHT = 30.0;
    private static final double GAP_BETWEEN_LEGS = 20.0;
    private static final double EYE_RADIUS = 5.0;
    private static final double GAP_BETWEEN_EYES = 50.0;
    private static final double ANTENNA_LENGTH = 85.0;

    public void run() {
        this.drawHead();
        this.drawBody();
        this.drawArms();
        this.drawLegs();
        this.drawEyes();
        this.drawAntennas();
        this.addLabel();
    }

    private void drawHead() {
        double d = (double)(this.getWidth() / 2) - 60.0;
        GOval gOval = new GOval(d, 100.0, 120.0, 120.0);
        gOval.setFilled(true);
        gOval.setColor(Color.GREEN);
        this.add((GObject)gOval);
        GRect gRect = new GRect(d, 160.0, 121.0, 61.0);
        gRect.setFilled(true);
        gRect.setColor(Color.WHITE);
        this.add((GObject)gRect);
    }

    private void drawBody() {
        double d = (double)(this.getWidth() / 2) - 60.0;
        double d2 = 165.0;
        double d3 = 120.0;
        GRect gRect = new GRect(d, d2, d3, 95.0);
        gRect.setFilled(true);
        gRect.setColor(Color.GREEN);
        this.add((GObject)gRect);
    }

    private void drawArm(double d, double d2) {
        GOval gOval = new GOval(d, d2, 24.0, 24.0);
        gOval.setFilled(true);
        gOval.setColor(Color.GREEN);
        this.add((GObject)gOval);
        GOval gOval2 = new GOval(d, d2 + 70.0, 24.0, 24.0);
        gOval2.setFilled(true);
        gOval2.setColor(Color.GREEN);
        this.add((GObject)gOval2);
        GRect gRect = new GRect(d - 1.0, d2 + 12.0, 26.0, 70.0);
        gRect.setFilled(true);
        gRect.setColor(Color.GREEN);
        this.add((GObject)gRect);
    }

    private void drawArms() {
        double d = (double)(this.getWidth() / 2) - 60.0 - 7.0 - 24.0;
        double d2 = 165.0;
        this.drawArm(d, d2);
        double d3 = (double)(this.getWidth() / 2) + 60.0 + 7.0;
        this.drawArm(d3, d2);
    }

    private void drawLeg(double d, double d2) {
        GOval gOval = new GOval(d, d2 + 30.0 - 14.0, 28.0, 28.0);
        gOval.setFilled(true);
        gOval.setColor(Color.GREEN);
        this.add((GObject)gOval);
        GRect gRect = new GRect(d, d2, 29.0, 30.0);
        gRect.setFilled(true);
        gRect.setColor(Color.GREEN);
        this.add((GObject)gRect);
    }

    private void drawLegs() {
        double d = (double)(this.getWidth() / 2) - 10.0 - 28.0;
        double d2 = 260.0;
        this.drawLeg(d, d2);
        double d3 = (double)(this.getWidth() / 2) + 10.0;
        this.drawLeg(d3, d2);
    }

    private void drawEye(double d, double d2) {
        GOval gOval = new GOval(d, d2, 10.0, 10.0);
        gOval.setFilled(true);
        gOval.setColor(Color.WHITE);
        this.add((GObject)gOval);
    }

    private void drawEyes() {
        double d = (double)(this.getWidth() / 2) - 25.0 - 10.0;
        double d2 = 130.0;
        this.drawEye(d, d2);
        double d3 = (double)(this.getWidth() / 2) + 25.0;
        this.drawEye(d3, d2);
    }

    private void drawAntenna(double d) {
        double d2 = this.getWidth() / 2;
        double d3 = 160.0;
        GLine gLine = new GLine(d2, d3, d2 + 85.0 * Math.cos(d), d3 - 85.0 * Math.sin(d));
        gLine.setColor(Color.GREEN);
        this.add((GObject)gLine);
    }

    private void drawAntennas() {
        this.drawAntenna(1.0471975511965976);
        this.drawAntenna(2.0943951023931953);
    }

    private void addLabel() {
        GLabel gLabel = new GLabel("Artistry by Meng Ye");
        gLabel.setFont("Bold-15");
        gLabel.setLocation((double)this.getWidth() - gLabel.getWidth(), (double)this.getHeight() - gLabel.getAscent());
        this.add((GObject)gLabel);
    }
}

