/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double HORIZON_LINE_HEIGHT = 350.0;
    private static final double RADIUS_SUN = 75.0;
    private static final int N_STEPS = 100;
    private static final int PAUSE_TIME = 50;
    private static final int LENGTH_OF_DAYTIME = 2000;
    private static final double CACTUS_HEIGHT = 150.0;
    private static final double CACTUS_WIDTH = 80.0;
    private static final double ROOT_WIDTH = 20.0;
    private static final double BRANCH_HEIGHT = 45.0;
    private static final double BRANCH_THICKNESS = 10.0;
    private static final double LITTLE_BRANCH_HEIGHT = 20.0;
    private static final double LITTLE_BRANCH_WIDTH = 15.0;
    private static final double Y_CACTUS = 70.0;
    private static final double X_CACTUS = 150.0;
    private static final double RAILROAD_WIDTH = 150.0;
    private static final double DISTANCE_TRACKS_APART = 20.0;
    private static final Color SKY_COLOR = new Color(150, 225, 225);
    private static final Color RISING_SUN = new Color(255, 155, 0);
    private static final Color SAND = new Color(255, 130, 0);
    private static final Color CACTUS_GREEN = new Color(0, 170, 0);

    public void run() {
        GRect gRect = this.sky();
        GOval gOval = this.sun();
        this.add((GObject)gRect);
        this.add((GObject)gOval);
        this.addDesert();
        this.signName();
        this.duskToDay(gOval, gRect, RISING_SUN, SKY_COLOR);
        this.pause(2000.0);
        this.dayToNight(gOval, gRect, RISING_SUN, SKY_COLOR);
        this.moonAppears(SKY_COLOR);
    }

    private GRect sky() {
        GRect gRect = this.filledRect(0.0, 0.0, this.getWidth(), this.getHeight(), SKY_COLOR);
        return gRect;
    }

    private GOval sun() {
        GOval gOval = this.filledOval(0.0, (double)this.getHeight() - 150.0, 75.0, RISING_SUN);
        return gOval;
    }

    private void addDesert() {
        this.add((GObject)this.desert());
        this.drawRailroad();
        this.drawCactus(150.0, 280.0);
    }

    private GRect desert() {
        GRect gRect = this.filledRect(0.0, 350.0, this.getWidth(), this.getHeight(), SAND);
        return gRect;
    }

    private void drawCactus(double d, double d2) {
        GRect gRect = this.filledRect(d, d2, 20.0, 150.0, CACTUS_GREEN);
        double d3 = d - 30.0;
        GRect gRect2 = this.filledRect(d3, d2 + 45.0, 80.0, 10.0, CACTUS_GREEN);
        GRect gRect3 = this.filledRect(d3 + 80.0 - 15.0, d2 + 45.0 - 20.0, 15.0, 20.0, CACTUS_GREEN);
        GRect gRect4 = this.filledRect(d3, d2 + 45.0 - 20.0, 15.0, 20.0, CACTUS_GREEN);
        this.add((GObject)gRect);
        this.add((GObject)gRect2);
        this.add((GObject)gRect3);
        this.add((GObject)gRect4);
    }

    private void drawRailroad() {
        this.add((GObject)new GLine((double)(this.getWidth() / 2), 350.0, (double)(this.getWidth() / 2) - 75.0, (double)this.getHeight()));
        this.add((GObject)new GLine((double)(this.getWidth() / 2), 350.0, (double)(this.getWidth() / 2) + 75.0, (double)this.getHeight()));
        for (double d = 350.0; d <= (double)this.getHeight(); d += 20.0) {
            double d2 = ((double)this.getHeight() - 350.0) / 75.0;
            double d3 = (d - (350.0 - d2 * (double)(this.getWidth() / 2))) / d2;
            double d4 = (d - (350.0 + d2 * (double)(this.getWidth() / 2))) / -d2;
            this.add((GObject)new GLine(d4, d, d3, d));
        }
    }

    private void duskToDay(GOval gOval, GRect gRect, Color color, Color color2) {
        double d = this.getWidth() / 2 / 100;
        double d2 = (this.getHeight() - 100) / 100;
        for (int i = 0; i < 100; ++i) {
            gOval.move(d, -d2);
            Color color3 = new Color(color.getRed(), color.getGreen() + i, color.getBlue() + i);
            Color color4 = new Color(color2.getRed() - i, color2.getGreen() - i, color2.getBlue());
            gRect.setColor(color4);
            gOval.setColor(color3);
            this.pause(50.0);
        }
    }

    private void dayToNight(GOval gOval, GRect gRect, Color color, Color color2) {
        double d = ((double)this.getWidth() - 75.0) / 2.0 / 100.0;
        double d2 = this.getHeight() / 100;
        for (int i = 0; i <= 100; ++i) {
            gOval.move(d, d2);
            Color color3 = new Color(color2.getRed() - 100, color2.getGreen() - 100 - i, color2.getBlue() - i);
            gRect.setColor(color3);
            Color color4 = new Color(color.getRed(), color.getGreen() + 100 - i * 2, color.getBlue() + 100);
            gOval.setColor(color4);
            this.pause(50.0);
        }
    }

    private void moonAppears(Color color) {
        Color color2 = new Color(color.getRed() - 100, color.getGreen() - 200, color.getBlue() - 100);
        GOval gOval = this.filledOval((double)(this.getWidth() / 2) - 75.0, 100.0, 75.0, color2);
        this.add((GObject)gOval);
        for (int i = 0; i <= 100; ++i) {
            Color color3 = new Color(49 + i * 2, 23 + i * 2, 154 + i);
            gOval.setColor(color3);
            this.pause(50.0);
        }
    }

    private void signName() {
        GLabel gLabel = new GLabel("Artistry by Mihika Hemmady");
        double d = gLabel.getWidth();
        this.add((GObject)gLabel, (double)this.getWidth() - d, this.getHeight());
    }

    private GRect filledRect(double d, double d2, double d3, double d4, Color color) {
        GRect gRect = new GRect(d, d2, d3, d4);
        gRect.setFilled(true);
        gRect.setColor(color);
        return gRect;
    }

    private GOval filledOval(double d, double d2, double d3, Color color) {
        GOval gOval = new GOval(d, d2, 2.0 * d3, 2.0 * d3);
        gOval.setFilled(true);
        gOval.setColor(color);
        return gOval;
    }
}

