/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPolygon;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double EDGE_LENGTH = 40.0;
    private static final double ROTATION_NUMBER = 6.0;
    private static final double PAUSE_TIME = 1000.0;
    private static final Color purple = new Color(150, 0, 150);

    public void run() {
        this.writeTitle();
        this.pause(1000.0);
        this.writeInspiration();
        this.pause(1000.0);
        this.drawPattern();
        this.pause(1000.0);
        this.writeName();
    }

    private void drawPattern() {
        double d = this.getWidth() / 2;
        double d2 = (double)(this.getHeight() / 2) + 40.0;
        this.drawOval(d, d2);
        this.pause(1000.0);
        this.drawTrapezoids(d, d2);
        this.pause(1000.0);
        this.drawOuterSquares(d, d2);
        this.pause(1000.0);
        this.drawBlueRhombi(d, d2);
        this.pause(1000.0);
        this.drawOuterTriangles(d, d2);
        this.pause(1000.0);
        this.drawWhiteRhombi(d, d2);
        this.pause(1000.0);
        this.drawInnerTriangles(d, d2);
        this.pause(1000.0);
        this.drawInnerSquares(d, d2);
        this.pause(1000.0);
        this.drawHexagon(d, d2);
    }

    private void drawSymmetric(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, Color color, double d15, double d16) {
        GPolygon gPolygon = new GPolygon(d15, d16 - 40.0);
        gPolygon.addVertex(0.0, 0.0);
        double d17 = 0.0;
        int n = 0;
        while ((double)n < 6.0) {
            gPolygon = this.drawOnePart(gPolygon, d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d17);
            d17 -= 60.0;
            ++n;
        }
        gPolygon.setFilled(true);
        gPolygon.setFillColor(color);
        this.add((GObject)gPolygon);
    }

    private GPolygon drawOnePart(GPolygon gPolygon, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15) {
        gPolygon.addPolarEdge(d * 40.0, d2 + d15);
        gPolygon.addPolarEdge(d3 * 40.0, d4 + d15);
        gPolygon.addPolarEdge(d5 * 40.0, d6 + d15);
        gPolygon.addPolarEdge(d7 * 40.0, d8 + d15);
        gPolygon.addPolarEdge(d9 * 40.0, d10 + d15);
        gPolygon.addPolarEdge(d11 * 40.0, d12 + d15);
        gPolygon.addPolarEdge(d13 * 40.0, d14 + d15);
        return gPolygon;
    }

    private void drawOval(double d, double d2) {
        double d3 = 40.0 + 160.0 * Math.sin(1.0471975511965976);
        GOval gOval = new GOval(d - d3, d2 - d3, 2.0 * d3, 2.0 * d3);
        gOval.setFilled(true);
        this.add((GObject)gOval);
    }

    private void drawTrapezoids(double d, double d2) {
        this.drawSymmetric(1.0, 60.0, 2.0, 90.0, 3.0, 330.0, 2.0, 210.0, 1.0, 240.0, 0.0, 0.0, 0.0, 0.0, Color.RED, d, d2);
    }

    private void drawOuterSquares(double d, double d2) {
        this.drawSymmetric(1.0, 60.0, 2.0, 90.0, 1.0, 180.0, 2.0, 270.0, 1.0, 300.0, 1.0, 330.0, 0.0, 0.0, Color.ORANGE, d, d2);
    }

    private void drawBlueRhombi(double d, double d2) {
        this.drawSymmetric(1.0, 60.0, 2.0, 30.0, 1.0, 90.0, 1.0, 210.0, 2.0, 270.0, 1.0, 240.0, 0.0, 0.0, Color.BLUE, d, d2);
    }

    private void drawOuterTriangles(double d, double d2) {
        this.drawSymmetric(1.0, 90.0, 1.0, 120.0, 1.0, 0.0, 1.0, 240.0, 1.0, 270.0, 1.0, 330.0, 0.0, 0.0, Color.GREEN, d, d2);
    }

    private void drawWhiteRhombi(double d, double d2) {
        this.drawSymmetric(1.0, 90.0, 1.0, 60.0, 1.0, 270.0, 1.0, 330.0, 1.0, 30.0, 1.0, 240.0, 1.0, 210.0, Color.WHITE, d, d2);
    }

    private void drawInnerTriangles(double d, double d2) {
        this.drawSymmetric(1.0, 60.0, 1.0, 30.0, 1.0, 270.0, 1.0, 240.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Color.GREEN, d, d2);
    }

    private void drawInnerSquares(double d, double d2) {
        this.drawSymmetric(1.0, 60.0, 1.0, 330.0, 1.0, 240.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Color.ORANGE, d, d2);
    }

    private void drawHexagon(double d, double d2) {
        this.drawSymmetric(1.0, -30.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Color.YELLOW, d, d2);
    }

    private void writeInspiration() {
        GLabel gLabel = new GLabel("Inspired by Pattern Blocks");
        gLabel.setFont("Rockwell-30");
        gLabel.setColor(purple);
        double d = (double)(this.getWidth() / 2) - gLabel.getWidth() / 2.0;
        double d2 = gLabel.getAscent() + 50.0;
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }

    private void writeTitle() {
        GLabel gLabel = new GLabel("Kaleidoscope");
        gLabel.setFont("Rockwell-35");
        gLabel.setColor(purple);
        double d = (double)(this.getWidth() / 2) - gLabel.getWidth() / 2.0;
        double d2 = gLabel.getAscent();
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }

    private void writeName() {
        GLabel gLabel = new GLabel("Artistry by Margaret Koehler ");
        gLabel.setFont("Rockwell-20");
        gLabel.setColor(purple);
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getDescent();
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }
}

