/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GPen;
import acm.graphics.GRect;
import acm.graphics.GTurtle;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double PEN_SPEED = 0.7;
    private static final int SPIRAL_SIZE = 250;

    public void run() {
        this.hypnotize(Color.BLUE);
        this.spiralRise();
        this.signature();
        this.cuteTurtle();
    }

    private void hypnotize(Color color) {
        GRect gRect = new GRect(0.0, 0.0, (double)this.getWidth(), (double)this.getHeight());
        this.add((GObject)gRect);
        gRect.setFilled(true);
        gRect.setFillColor(Color.ORANGE);
        GPen gPen = new GPen((double)(this.getWidth() / 2), (double)(this.getHeight() / 2));
        this.add((GObject)gPen);
        gPen.setSpeed(0.7);
        gPen.setColor(color);
        double d = 5.0;
        double d2 = 0.0;
        this.drawSpiral(gPen, gRect, d, d2);
    }

    private void drawSpiral(GPen gPen, GRect gRect, double d, double d2) {
        for (int i = 0; i < 250; ++i) {
            gPen.drawPolarLine(d, d2);
            d2 += 30.0;
            if ((d += 1.0) % 2.0 == 0.0) {
                gRect.setFillColor(Color.MAGENTA);
                continue;
            }
            gRect.setFillColor(Color.ORANGE);
        }
    }

    private void spiralRise() {
        GRect gRect = this.setBackgroundOrange();
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        for (int i = 0; i < 285; ++i) {
            GPen gPen = new GPen((double)n, (double)n2);
            this.add((GObject)gPen);
            gPen.setSpeed(1.0);
            gPen.setColor(Color.BLACK);
            double d = 5.0;
            double d2 = 0.0;
            this.drawSpiral(gPen, gRect, d, d2);
            --n2;
            this.pause(6.0);
        }
    }

    private GRect setBackgroundOrange() {
        GRect gRect = new GRect(0.0, 0.0, (double)this.getWidth(), (double)this.getHeight());
        this.add((GObject)gRect);
        gRect.setFilled(true);
        gRect.setFillColor(Color.ORANGE);
        return gRect;
    }

    private void signature() {
        GLabel gLabel = new GLabel("Artistry by Nayantara Jain", (double)(this.getWidth() - 150), (double)(this.getHeight() - 5));
        this.add((GObject)gLabel);
        gLabel.setColor(Color.WHITE);
    }

    private void cuteTurtle() {
        GTurtle gTurtle = new GTurtle(0.0, (double)(this.getHeight() - 50));
        this.add((GObject)gTurtle);
        gTurtle.showTurtle();
        gTurtle.setSpeed(0.4);
        for (int i = 0; i < 50; ++i) {
            for (int j = 0; j < this.getWidth() / gTurtle.getTurtleSize(); ++j) {
                gTurtle.forward();
            }
            gTurtle.left(180.0);
        }
    }
}

