/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double SKY_HEIGHT = 45.0;
    private static final double MOON_LOCATION_X = 610.0;
    private static final double MOON_LOCATION_Y = 20.0;
    private static final double MOON_WIDTH = 50.0;
    private static final double MOON_HEIGHT = 50.0;
    private static final double SH_STAR_MIDDLE_X = 140.0;
    private static final double SH_STAR_MIDDLE_Y = 110.0;
    private static final double SECOND_SH_STAR_MIDDLE_X = 180.0;
    private static final double SECOND_SH_STAR_MIDDLE_Y = 120.0;
    private static final double THIRD_SH_STAR_MIDDLE_X = 200.0;
    private static final double THIRD_SH_STAR_MIDDLE_Y = 155.0;
    private static final double FOURTH_SH_STAR_MIDDLE_X = 230.0;
    private static final double FOURTH_SH_STAR_MIDDLE_Y = 190.0;
    private static final double FIFTH_SH_STAR_MIDDLE_X = 228.0;
    private static final double FIFTH_SH_STAR_MIDDLE_Y = 220.0;
    private static final double SIXTH_SH_STAR_MIDDLE_X = 290.0;
    private static final double SIXTH_SH_STAR_MIDDLE_Y = 210.0;
    private static final double SEVENTH_SH_STAR_MIDDLE_X = 273.0;
    private static final double SEVENTH_SH_STAR_MIDDLE_Y = 240.0;
    private static final double SH_STAR_RADIUS = 10.0;
    private static final int NUM_SH_STAR_POINTS = 5;

    public void run() {
        this.addGrass();
        this.addSky();
        this.addSnow();
        this.addDipper();
        this.addMoon();
        this.addSignature();
    }

    private void addGrass() {
        GRect gRect = new GRect((double)this.getWidth(), (double)this.getHeight());
        gRect.setFilled(true);
        gRect.setColor(Color.GREEN);
        this.add((GObject)gRect);
    }

    private void addSky() {
        double d = (double)this.getHeight() - 45.0;
        GRect gRect = new GRect(0.0, 0.0, (double)this.getWidth(), d);
        gRect.setFilled(true);
        gRect.setColor(Color.BLACK);
        this.add((GObject)gRect);
    }

    private void addSnow() {
        double d = (double)this.getHeight() - 45.0;
        GLine gLine = new GLine(0.0, d, (double)this.getWidth(), d);
        gLine.setColor(Color.WHITE);
        this.add((GObject)gLine);
    }

    private void addDipper() {
        this.addStar(140.0, 110.0);
        this.addStar(180.0, 120.0);
        this.addStar(200.0, 155.0);
        this.addStar(230.0, 190.0);
        this.addStar(228.0, 220.0);
        this.addStar(290.0, 210.0);
        this.addStar(273.0, 240.0);
    }

    private void addStar(double d, double d2) {
        for (int i = 0; i < 5; ++i) {
            double d3 = (double)(i * 2) * Math.PI / 5.0;
            double d4 = (double)((i + 2) * 2) * Math.PI / 5.0;
            GLine gLine = new GLine(d + 10.0 * Math.cos(d3), d2 - 10.0 * Math.sin(d3), d + 10.0 * Math.cos(d4), d2 - 10.0 * Math.sin(d4));
            gLine.setColor(Color.YELLOW);
            this.add((GObject)gLine);
        }
    }

    private void addMoon() {
        GOval gOval = new GOval(610.0, 20.0, 50.0, 50.0);
        gOval.setFilled(true);
        gOval.setColor(Color.BLUE);
        gOval.setFillColor(Color.WHITE);
        this.add((GObject)gOval);
    }

    private void addSignature() {
        GLabel gLabel = new GLabel("Artistry by Nicholas P. Moores");
        gLabel.setFont("Serif-18");
        gLabel.setColor(Color.RED);
        this.add((GObject)gLabel);
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = this.getHeight();
        gLabel.setLocation(d, d2);
    }
}

