/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double SUN_DIAMETER = 400.0;
    private static final double HULL_WIDTH = 200.0;
    private static final double HULL_HEIGHT = 70.0;
    private static final double MAST_WIDTH = 15.0;
    private static final double MAST_HEIGHT = 210.0;
    private static final double SAIL_WIDTH = 100.0;
    private static final double SAIL_HEIGHT = 70.0;
    private static final double PAUSE_TIME = 90.0;

    public void run() {
        this.makeSky();
        this.makeSunRise();
        this.makeOcean();
        this.makeBoat();
        this.makeSignature();
        this.showTitle();
    }

    private void makeSky() {
        GRect gRect = new GRect(0.0, 0.0, (double)this.getWidth(), (double)(this.getHeight() / 2));
        Color color = new Color(135, 206, 250);
        gRect.setColor(color);
        gRect.setFilled(true);
        gRect.setFillColor(color);
        this.add((GObject)gRect);
    }

    private void makeSunRise() {
        GOval gOval = new GOval(((double)this.getWidth() - 400.0) / 2.0, ((double)this.getHeight() - 400.0) / 2.0, 400.0, 400.0);
        gOval.setColor(Color.YELLOW);
        gOval.setFilled(true);
        gOval.setFillColor(Color.YELLOW);
        this.add((GObject)gOval);
    }

    private void makeOcean() {
        GRect gRect = new GRect(0.0, (double)(this.getHeight() / 2), (double)this.getWidth(), (double)this.getHeight());
        gRect.setColor(Color.BLUE);
        gRect.setFilled(true);
        gRect.setFillColor(Color.BLUE);
        this.add((GObject)gRect);
    }

    private void makeBoat() {
        this.createHull();
        this.createMast();
        this.createSail();
    }

    private void createHull() {
        GRect gRect = new GRect(((double)this.getWidth() - 200.0) / 2.0, ((double)this.getHeight() + 140.0) / 2.0, 200.0, 70.0);
        Color color = new Color(139, 69, 19);
        gRect.setColor(color);
        gRect.setFilled(true);
        gRect.setFillColor(color);
        this.add((GObject)gRect);
    }

    private void createMast() {
        GRect gRect = new GRect((double)(this.getWidth() / 2), (double)(this.getHeight() / 2) - 70.0, 15.0, 210.0);
        Color color = new Color(139, 69, 19);
        gRect.setColor(color);
        gRect.setFilled(true);
        gRect.setFillColor(color);
        this.add((GObject)gRect);
    }

    private void createSail() {
        GRect gRect = new GRect((double)(this.getWidth() / 2) + 15.0, (double)(this.getHeight() / 2) - 70.0, 100.0, 70.0);
        gRect.setColor(Color.WHITE);
        gRect.setFilled(true);
        gRect.setFillColor(Color.WHITE);
        this.add((GObject)gRect);
    }

    private void makeSignature() {
        GLabel gLabel = new GLabel("NancyTPham");
        gLabel.setLocation((double)this.getWidth() - gLabel.getWidth() * 2.0, (double)this.getHeight() - gLabel.getAscent());
        gLabel.setFont("Helvetica-ITALIC-20");
        gLabel.setColor(Color.WHITE);
        this.add((GObject)gLabel);
    }

    private void showTitle() {
        GLabel gLabel = new GLabel("Cardboard Boat Floating In Ocean");
        gLabel.setLocation(-gLabel.getWidth() * 2.0, gLabel.getAscent() * 2.0);
        gLabel.setFont("SansSerif-30");
        this.add((GObject)gLabel);
        double d = (double)this.getWidth() / 90.0;
        double d2 = 0.0;
        while (true) {
            if (gLabel.getX() < (double)this.getWidth()) {
                gLabel.move(d, d2);
                this.pause(90.0);
                continue;
            }
            gLabel.setLocation(-gLabel.getWidth() * 2.0, gLabel.getAscent() * 2.0);
        }
    }
}

