/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GArc;
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    public static final Color PINK = new Color(255, 175, 175);
    private static final int SUN_RADIUS = 150;
    private static final int BOAT_RADIUS = 150;

    public void run() {
        double d = this.getWidth() / 2;
        double d2 = this.getHeight() / 2;
        this.addSky(0.0, 0.0);
        this.addSun(d - 150.0, d2 - 150.0);
        this.addOcean(0.0, d2);
        this.addBoat();
        this.addName();
    }

    private void addSun(double d, double d2) {
        this.drawSun(d, d2, 150.0, 150.0, Color.ORANGE);
    }

    private void addOcean(double d, double d2) {
        this.drawOcean(d, d2, this.getWidth(), this.getHeight(), Color.BLUE);
    }

    private void addSky(double d, double d2) {
        this.drawSky(d, d2, this.getWidth(), this.getHeight(), Color.PINK);
    }

    private void drawSun(double d, double d2, double d3, double d4, Color color) {
        GOval gOval = new GOval(d, d2, d3, d4);
        gOval.setColor(color);
        gOval.setFilled(true);
        this.add((GObject)gOval);
    }

    private void drawOcean(double d, double d2, double d3, double d4, Color color) {
        GRect gRect = new GRect(d, d2, d3, d4);
        gRect.setColor(color);
        gRect.setFilled(true);
        this.add((GObject)gRect);
    }

    private void drawSky(double d, double d2, double d3, double d4, Color color) {
        GRect gRect = new GRect(d, d2, d3, d4);
        gRect.setColor(color);
        gRect.setFilled(true);
        this.add((GObject)gRect);
    }

    private void addBoat() {
        double d = 150.0;
        GArc gArc = new GArc(2.0 * d, 2.0 * d, 0.0, -180.0);
        gArc.setFilled(true);
        gArc.setFillColor(Color.WHITE);
        this.add((GObject)gArc, this.getWidth() / 2, this.getHeight() / 2);
    }

    private void addName() {
        GLabel gLabel = new GLabel("Artistry by Rosalinda Cortez.");
        gLabel.setFont("SansSerif-bold-18");
        gLabel.setColor(Color.BLACK);
        this.add((GObject)gLabel, (double)this.getWidth() - gLabel.getWidth(), (double)this.getHeight() - gLabel.getAscent() / 2.0);
    }
}

