/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GArc;
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final String BYLINE_FONT = "Times New Roman-16";
    private static final int BYLINE_MARGIN = 10;
    private static final Color BYLINE_COLOR = Color.MAGENTA;
    private static final double STAR_RADIUS = 10.0;
    private static final Color STAR_COLOR = Color.YELLOW;
    private static final int NUM_STAR_POINTS = 5;
    private static final double FLAG_WIDTH = 600.0;
    private static final double FLAG_HEIGHT = 400.0;

    public void run() {
        this.drawFlag();
        this.drawDipper();
        this.drawNorthStar();
        this.addTitle("ALASKA");
        this.addByLine("Artistry by Robin Perani");
    }

    private void drawFlag() {
        GRect gRect = new GRect(0.0, 0.0, 600.0, 400.0);
        gRect.setFilled(true);
        gRect.setColor(Color.BLUE);
        this.add((GObject)gRect);
    }

    private void drawNorthStar() {
        this.drawFlagStar(0.83, 0.17);
        this.turnMeteor();
    }

    private void turnMeteor() {
        GArc gArc = new GArc(298.0, 58.0, 230.0, 60.0, 45.0, 100.0);
        gArc.setColor(Color.ORANGE);
        this.add((GObject)gArc);
    }

    private void drawDipper() {
        this.drawFlagStar(0.1, 0.4);
        this.drawFlagStar(0.25, 0.45);
        this.drawFlagStar(0.3, 0.55);
        this.drawFlagStar(0.37, 0.63);
        this.drawFlagStar(0.37, 0.77);
        this.drawFlagStar(0.57, 0.73);
        this.drawFlagStar(0.5, 0.83);
    }

    private void drawFlagStar(double d, double d2) {
        this.drawStar(d * 600.0, d2 * 400.0);
    }

    private void drawStar(double d, double d2) {
        for (int i = 0; i < 5; ++i) {
            double d3 = (double)(i * 2) * Math.PI / 5.0;
            double d4 = (double)((i + 2) * 2) * Math.PI / 5.0;
            GLine gLine = new GLine(d + 10.0 * Math.cos(d3), d2 - 10.0 * Math.sin(d3), d + 10.0 * Math.cos(d4), d2 - 10.0 * Math.sin(d4));
            gLine.setColor(STAR_COLOR);
            this.add((GObject)gLine);
        }
    }

    private void addTitle(String string) {
        GLabel gLabel = new GLabel(string, 10.0, 460.0);
        gLabel.setFont("Herculaneum-40-BOLDITALIC");
        gLabel.setColor(Color.CYAN);
        this.add((GObject)gLabel);
    }

    private void addByLine(String string) {
        GLabel gLabel = new GLabel(string, 0.0, 0.0);
        gLabel.setFont(BYLINE_FONT);
        gLabel.setColor(BYLINE_COLOR);
        double d = (double)(this.getWidth() - 10) - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getHeight();
        this.add((GObject)gLabel, d, d2);
    }
}

