/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GArc;
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double beakWidth = 144.0;
    private static final double beakHeight = 95.0;
    private static final double headDiameter = 72.0;
    private static final double eyeDiameter = 7.0;
    private static final double eyePatchDiameter = 15.0;
    private static final double neckPatchWidth = 30.0;
    private static final double neckPatchHeight = 70.0;
    private static final double neckWidth = 90.0;
    private static final double neckHeight = 100.0;
    private static final double bodyWidth = 90.0;
    private static final double bodyHeight = 80.0;
    private static final double branchWidth = 288.0;
    private static final double branchHeight = 20.0;
    private static final double featherWidth = 18.0;
    private static final double featherHeight = 72.0;

    public void run() {
        double d = this.getWidth() / 2;
        double d2 = this.getHeight() / 2;
        this.drawRect(d, d2, this.getWidth(), this.getHeight(), Color.CYAN);
        this.drawToucan();
        this.drawRect(d, d2 - 30.0, 288.0, 20.0, Color.getHSBColor(20.0f, 240.0f, 60.0f));
        this.drawToucanLabel();
        this.drawNameLabel();
    }

    private void drawOval(double d, double d2, double d3, double d4, Color color) {
        double d5 = d - d3 / 2.0;
        double d6 = d2 - d4 / 2.0;
        GOval gOval = new GOval(d5, d6, d3, d4);
        gOval.setColor(color);
        gOval.setFilled(true);
        this.add((GObject)gOval);
    }

    private void drawRect(double d, double d2, double d3, double d4, Color color) {
        double d5 = d - d3 / 2.0;
        double d6 = d2 - d4 / 2.0;
        GRect gRect = new GRect(d5, d6, d3, d4);
        gRect.setColor(color);
        gRect.setFilled(true);
        this.add((GObject)gRect);
    }

    private void drawLine(double d, double d2, double d3, double d4) {
        GLine gLine = new GLine(d, d2, d3, d4);
        this.add((GObject)gLine);
    }

    private void drawToucan() {
        this.drawBeak();
        this.drawBody();
        this.drawHead();
        this.drawTail();
    }

    private void drawBeak() {
        double d = this.getWidth() / 2;
        GArc gArc = new GArc(d - 126.0, (double)(this.getHeight() / 8), 144.0, 95.0, 0.0, 180.0);
        gArc.setColor(new Color(255, 129, 0));
        gArc.setFilled(true);
        this.add((GObject)gArc);
        this.drawLine(d - 126.0, (double)(this.getHeight() / 8) + 47.5, d, (double)(this.getHeight() / 8) + 23.75);
    }

    private void drawBody() {
        double d = this.getWidth() / 2;
        this.drawOval(d, (double)this.getHeight() / 3.5, 90.0, 100.0, Color.BLACK);
        this.drawRect(d, (double)this.getHeight() / 3.5 + 33.333333333333336, 90.0, 80.0, Color.BLACK);
    }

    private void drawHead() {
        double d = this.getWidth() / 2;
        this.drawOval(d, this.getHeight() / 5, 72.0, 72.0, Color.BLACK);
        this.drawOval(d - 18.0, (double)(this.getHeight() / 5) - 14.4, 15.0, 15.0, Color.GREEN);
        this.drawOval(d - 18.0, (double)(this.getHeight() / 5) - 14.4, 7.0, 7.0, Color.BLACK);
        this.drawOval(d - 18.0, (double)(this.getHeight() / 5) + 36.0, 30.0, 70.0, Color.WHITE);
    }

    private void drawTail() {
        double d = this.getWidth() / 2;
        double d2 = this.getHeight() / 2;
        for (int i = -2; i < 2; ++i) {
            this.drawOval(d + (double)i * 18.0 + 9.0, d2, 18.0, 72.0, Color.BLACK);
        }
    }

    private void drawToucanLabel() {
        double d = this.getWidth() / 2;
        double d2 = this.getHeight() / 2;
        GLabel gLabel = new GLabel("What a boss!");
        gLabel.setFont("SansSerif-bold-28");
        double d3 = d - gLabel.getWidth() / 2.0;
        gLabel.setLocation(d3, d2 + 100.0);
        this.add((GObject)gLabel);
    }

    private void drawNameLabel() {
        GLabel gLabel = new GLabel("Artistry by Raissa Largman");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getAscent() / 2.0;
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }
}

