/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPen;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double DIAMETER_OF_SUN = 50.0;
    private static final double DIAMETER_OF_PLANET = 30.0;
    private static final double PADDING = 3.0;
    private static final double SPOKE_LENGTH = 7.0;
    private double window_width;
    private double window_height;

    public void run() {
        this.window_width = this.getWidth();
        this.window_height = this.getHeight();
        this.addSpaceBackground();
        this.addSun();
        this.addEllipticalPath(0.75 * this.window_width, 0.4 * this.window_height, Color.ORANGE);
        this.addEllipticalPath(0.5 * this.window_width, 0.3 * this.window_height, Color.GREEN);
        this.addEllipticalPath(0.25 * this.window_width, 0.2 * this.window_height, Color.BLUE);
        this.addEllipticalPath(0.125 * this.window_width, 0.1 * this.window_height, Color.RED);
        this.addTitle();
        this.addSignature();
    }

    private void addSpaceBackground() {
        GRect gRect = new GRect(this.window_width, this.window_height);
        gRect.setFilled(true);
        this.add((GObject)gRect);
    }

    private void addSun() {
        GOval gOval = new GOval(this.window_width - 50.0 - 3.0, (this.window_height - 50.0) / 2.0, 50.0, 50.0);
        gOval.setFilled(true);
        gOval.setFillColor(Color.YELLOW);
        this.add((GObject)gOval);
        for (int i = 0; i < 10; ++i) {
            GPen gPen = new GPen(this.window_width - 25.0 - 3.0, this.window_height / 2.0);
            gPen.drawPolarLine(32.0, (double)(i * 36));
            gPen.setColor(Color.YELLOW);
            this.add((GObject)gPen);
        }
    }

    private void addEllipticalPath(double d, double d2, Color color) {
        double d3 = 2.0 * (this.window_width - d);
        double d4 = this.window_height - 2.0 * d2;
        GOval gOval = new GOval(d, d2, d3, d4);
        gOval.setColor(Color.WHITE);
        this.add((GObject)gOval);
        this.addPlanet(d, d2, color, d4);
    }

    private void addPlanet(double d, double d2, Color color, double d3) {
        double d4 = d;
        double d5 = d2 + d3 / 2.0;
        GOval gOval = new GOval(d4 - 15.0, d5 - 15.0, 30.0, 30.0);
        gOval.setFillColor(color);
        gOval.setFilled(true);
        this.add((GObject)gOval);
    }

    private void addTitle() {
        GLabel gLabel = new GLabel("Planets Align !");
        gLabel.setFont("Georgia-ITALIC-32");
        gLabel.setColor(Color.WHITE);
        double d = gLabel.getWidth();
        double d2 = gLabel.getHeight();
        double d3 = (this.window_width - d) / 2.0;
        double d4 = d2;
        gLabel.setLocation(d3, d4);
        this.add((GObject)gLabel);
    }

    private void addSignature() {
        GLabel gLabel = new GLabel("Artistry by Rukmani Ravi Sundaram");
        gLabel.setFont("Georgia");
        gLabel.setColor(Color.WHITE);
        double d = gLabel.getWidth();
        double d2 = this.window_width - d - 3.0;
        double d3 = this.window_height - 3.0;
        gLabel.setLocation(d2, d3);
        this.add((GObject)gLabel);
    }
}

